/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_UNIEXP_OPENGL_H
#define UX_UNIEXP_OPENGL_H


#include <uniexp/Functors_opengl.h>


#define UX_UNIEXP_OPENGL_MAX_RAND_TREES 100
#define UX_UNIEXP_OPENGL_MAX_RAND_X 51
#define UX_UNIEXP_OPENGL_MAX_RAND_Y 51
#define UX_UNIEXP_OPENGL_MAX_RAND_Z 1.4


namespace ux {



/** A plataforma gráfica.
 */
class UniEXP_opengl : public Art_VA {
  friend std::istream& operator>>(std::istream& is, UniEXP_opengl& ux);
  friend std::ostream& operator<<(std::ostream& os, const UniEXP_opengl& ux);
  /** inicia a janela opengl com atributos */
  UniEXP_opengl(const Attrs* attrs = 0);
  UniEXP_opengl(const UniEXP_opengl& src);
  UniEXP_opengl& operator=(const UniEXP_opengl& src);
  static UniEXP_opengl* singleton;
protected:
  /** camera */
  Camera camera;
  /** controle de frames */
  RealTime realTime;
  /** uma base giratória */
  Spinner spinner;
  /** start drawing loop */
  void startDrawing();
  /** start drawing loop */
  void startEvents();
public:
  static UniEXP_opengl* Instance(const Attrs* attrs = 0);
 ~UniEXP_opengl();
  /** atributos globais */
  Attrs* getAttrs() { return _attrs.ptr(); }
  /** atributos globais */
  const Attrs* getAttrs() const { return _attrs.ptr(); }
  /** inicialização das coordenadas de cena e camera, cor de fundo e framerate */
  void setupScene();
  /** inicialização das luzes de cena */
  void setupLights();
  /** configurações de material do motor OpenGL */
  void setupMaterials();
  /** all setup at once */
  void setup();
  /** varredura de criação da geometria - default = new Attrs("rootAttrs", "UniEXP_opengl") */
  void setupGeom(const Attrs* raizAttrs = 0);
  /** varredura de criação da geometria */
  void setupGeom(int numTrees = 1,
		 size_t _maxChild = 7, size_t _maxDeep = 10, size_t _maxDesc = 16200,
		 Coord3 _randLeafConicRatio = Coord3(0.54, 0.28, 0.92), unsigned int randomSeed = RANDOM_SEED,
		 Coord conic = 17.f, Coord ratio = 1.0f);

  /** varredura de desenho da geometria */
  void createGeom(Attrs* attrs = 0);

  /** reinicia buffers e matriz de perpectiva a cada frame */
  void drawInit();
  /** varredura de desenho da geometria */
  void calcGeom(Attrs* attrs = 0);
  /** varredura de desenho da geometria */
  void drawGeom(Attrs* attrs = 0);
  /** sincronização e swapping */
  void drawSwap();
  int isDrawing;
  /** start events and drawing threads */
  void start();
  /** métodos de acesso a _attrs */
  Uint32 width     () const;
  Uint32 height    () const;
  Uint32 bpp       () const;
  Uint32 resizable () const;
  Uint32 fullscreen() const;
  float  framespsec() const;
  /** atalhos */
  void doSpin(unsigned int arg) { spinner.doSpin(arg); }
};


/** draw main loop */
static int __startDrawing(void*);


}; /* namespace ux */


#endif /* UX_UNIEXP_OPENGL_H */

