/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_PROG_H
#define UX_PROG_H


#include <fstream>
#include <map>


typedef std::multimap<char, std::string>       _mm_cs;
typedef _mm_cs::value_type                    _pmm_cs;
typedef _mm_cs::iterator                      _imm_cs;
typedef _mm_cs::const_iterator               _cimm_cs;
typedef std::pair<_imm_cs, bool>              _Bmm_cs;
typedef std::pair<_imm_cs, _imm_cs>           _Imm_cs;
typedef std::pair<_cimm_cs, _cimm_cs>        _CImm_cs;

extern char* optarg;
extern int optind, opterr, optopt;

/** gerenciamento de opções.
 *  O construtor de Getopts obtém uma lista de caracteres
 *  de opção, adiciona "e:s:", as opções para entrada e
 *  saída de arquivos.
 *
 *  o método extract() extrai, efetivamente, opções passadas
 *  em linha de comando; parâmetros em argv não interceptados
 *  são acumulados sob (múltiplos) índices '#'.
 */
class Getopts: public _mm_cs {
  std::string _op;
  Getopts(const Getopts&);
public:
  Getopts(const std::string& ops = "") : _op(ops) { }
  void extract(int* argc, char*** argv);
  std::string op(char key) const;
  std::string options(const std::string& sep = ", ") const;
};


/** obtém tempo atual em segundos, como double, precisão usec */
double now();
/** obtém tempo atual em segundos, imprime rótulo em STDERR */
double now(const std::string&);
/** obtém tempo atual em segundos, imprime rótulo e (t_atual - t_ref) em STDERR */
double now(const std::string&, double t_ref);


#endif  /* UX_PROG_H */

