/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_PERL_H
#define UX_PERL_H


#include <string.h>

#define BUFF_1 1024
#define BUFF_4 4096


/** inicia um interpretador Perl persistente.
 *  esta função deve ser executada no início do bloco main(),
 *  com ponteiros para os parãmetros originais do programa.
 *
 *  dada a persistência do interpretador, deve-se utilizar
 *  sempre variáveis e subrotinas em escopo de package.
 */
int  perl_ini(int* a, char*** b, char*** c);
/** encerra e destrói o interpretador Perl. */
void perl_fim();

/** compila e executa script arqv com cache opcional */
void perl_arq(const char* arqv, bool cache=true);

/** compila e armazena uma única subrotina.
 *  além de "sub nome { ... }", a única construção válida
 *  é um prefixo de namespace "package pack;", que também
 *  pode ser escrito como "sub pack::nome { ... }".
 */
void perl_sub(const char* sub);

/** compila e executa perl (sem cache???) */
void         perl_exe (const char* cod);
/** compila e avalia, retorna escalar como int */
int          perl_int (const char* cod);
/** compila e avalia, retorna escalar como unsigned int */
unsigned int perl_uint(const char* cod);
/** compila e avalia, retorna escalar como double */
double       perl_dbl (const char* cod);
/** compila e avalia, retorna escalar como std::string */
const char*  perl_str (const char* cod);


void perl_exe_tty();
void perl_sub_tty();
void perl_arq_tty(bool cache=true);

#endif // UX_PERL_H

