/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_NUMBERS_H
#define UX_NUMBERS_H


#include <iostream>


#ifdef UNIEXP_MATH_FLOAT
#define Coord float
#else
#define Coord double
#endif


#define RAND_VECTOR_LENGTH 32
#define RAND_DOMAIN 1024
#define RANDOM_SEED 314076918


namespace ux {


/** Gerador de aleatórios
 */
class baseRandom {
  unsigned int _seed; /**< semente randômica */
  size_t _randVectorLen; /**< tamanho do estado randômico */
  char* _randVector; /**< estado randômico */
public:
  baseRandom(unsigned int seed = 0,
	     size_t randVectorLen = RAND_VECTOR_LENGTH);
 ~baseRandom();
  void reinit(unsigned int seed = 0);
  unsigned int getSeed() const { return _seed; }
};

/** Gerador de unsigned ints aleatórios
 */
class URandom : public baseRandom {
  size_t _randDomain; /**< número de possibilidades */
public:
  URandom(unsigned int seed = 0,
	  size_t randDomain = RAND_DOMAIN,
	  size_t randVectorLen = RAND_VECTOR_LENGTH);
  size_t domain () const;
  unsigned int operator()() const;
};


/** Gerador de doubles aleatórios
 */
class Random : public baseRandom {
  friend std::istream& operator>>(std::istream& is, Random& rn);
  friend std::ostream& operator<<(std::ostream& os, const Random& rn);
protected:
  double _low;
  double _high;
  double _delta;
public:
  Random (double low = 0.0, double high = 1.0,
	  unsigned int seed = 0, size_t randVectorLen = RAND_VECTOR_LENGTH);
  const Random& setRange(double low = 0.0, double high = 1.0);
  double min() const;
  double max() const;
  double operator()() const;
};

}; /* namespace ux */

#endif /* UX_NUMBERS_H */

