/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_FUNCTORS_OPENGL_H
#define UX_FUNCTORS_OPENGL_H


#include <iostream>

#include <uniexp/UniEXP.h>
#include <uniexp/Base_opengl.h>


namespace ux {


/** _fn_createGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico
 */
class _fn_createGeom : public _fn_varr {
  friend std::istream& operator>>(std::istream& is, _fn_createGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_createGeom& fn);
protected:
  size_t _leafs; /**< maximum number of children per node */
  size_t _deep; /**< maximum absolute deepness of the tree */
  size_t _maxi; /**< maximum number of descendants */
  Coord _conic; /**< angle between axis and each arm */
  Coord _ratio; /**< arm length */
public:
  _fn_createGeom();
  _fn_createGeom(const _fn_createGeom& src);
  _fn_createGeom(const std::string& tp, const std::string& id = "noid");
  _fn_createGeom(const std::string& id,
		 size_t maxChild, size_t maxDeep, size_t maxDesc,
		 Coord conic = 30.f, Coord ratio = 1.0f);
  virtual ~_fn_createGeom();

  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_createGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_createGeom(*this); }

  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};


/** _fn_createRandomGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico;
 */
class _fn_createRandomGeom : public _fn_createGeom {
  friend std::istream& operator>>(std::istream& is, _fn_createRandomGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_createRandomGeom& fn);
protected:
  Coord3 _randLeafConicRatio; /** random factor for leafs(X), conic(Y) and length ratio(Z) */
  Random _alea;
public:
  _fn_createRandomGeom();
  _fn_createRandomGeom(const _fn_createRandomGeom& src);
  _fn_createRandomGeom(const std::string& tp, const std::string& id = "noid");
  _fn_createRandomGeom(const std::string& id,
		       size_t maxChild, size_t maxDeep, size_t maxDesc,
		       Coord3 randLCR = Coord3(0.54, 0.28, 0.92), unsigned int randomSeed = 0,
		       Coord conic = 17.f, Coord ratio = 1.0f);
  virtual ~_fn_createRandomGeom();

  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_createRandomGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_createRandomGeom(*this); }
  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};


/** _fn_calcGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico
 */
class _fn_calcGeom : public _fn_varr {
  friend std::istream& operator>>(std::istream& is, _fn_calcGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_calcGeom& fn);
protected:
  size_t _mode;
  Random _alea;
public:
  _fn_calcGeom();
  _fn_calcGeom(const _fn_calcGeom& src);
  _fn_calcGeom(const std::string& tp, const std::string& id = "noid");
  _fn_calcGeom(const std::string& id,
	       size_t mode, unsigned int randomSeed = 0);
  virtual ~_fn_calcGeom();

  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_calcGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_calcGeom(*this); }
  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};


/** _fn_popGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico
 */
class _fn_popGeom : public _fn_varr {
  friend std::istream& operator>>(std::istream& is, _fn_popGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_popGeom& fn);
protected:
  size_t _mode;
  Random _alea;
  GLint maxStackDepth;
  GLint stackDepth;
public:
  _fn_popGeom();
  _fn_popGeom(const _fn_popGeom& src);
  _fn_popGeom(const std::string& tp, const std::string& id = "noid");
  _fn_popGeom(const std::string& id,
	      size_t mode, unsigned int randomSeed = 0);
  virtual ~_fn_popGeom();

  virtual void init(); 
  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_popGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_popGeom(*this); }

  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};



/** _fn_pushGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico
 */
class _fn_pushGeom : public _fn_popGeom {
  friend std::istream& operator>>(std::istream& is, _fn_pushGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_pushGeom& fn);
public:
  _fn_pushGeom();
  _fn_pushGeom(const _fn_pushGeom& src);
  _fn_pushGeom(const std::string& tp, const std::string& id = "noid");
  _fn_pushGeom(const std::string& id,
	       size_t mode, unsigned int randomSeed = 0);
  virtual ~_fn_pushGeom();

  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_pushGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_pushGeom(*this); }
  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};


/** _fn_drawGeom.
    cria uma hieraquia de atributos na árvore;
    depende da inicialização do contexto gráfico;
    não acessa o contexto gráfico
 */
class _fn_drawGeom : public _fn_pushGeom {
  friend std::istream& operator>>(std::istream& is, _fn_drawGeom& fn);
  friend std::ostream& operator<<(std::ostream& os, const _fn_drawGeom& fn);
protected:
  GLUquadricObj* qobj;
public:
  _fn_drawGeom();
  _fn_drawGeom(const _fn_drawGeom& src);
  _fn_drawGeom(const std::string& tp, const std::string& id = "noid");
  _fn_drawGeom(const std::string& id,
	       size_t mode, unsigned int randomSeed = 0);
  virtual ~_fn_drawGeom();

  /** redefinir em cada subclasse */
  virtual Clonable* factory() const { return new _fn_drawGeom(); }
  /** redefinir em cada subclasse */
  virtual Clonable* clone() const { return new _fn_drawGeom(*this); }
  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual void operator() (Art_0* art, Attrs* attrs = 0);
};



}; /* namespace ux */


#endif /* UX_FUNCTORS_OPENGL_H */

