/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_BASE_OPENGL_H
#define UX_BASE_OPENGL_H


#include <SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include <uniexp/Numbers.h>
#include <uniexp/Vectors.h>
//#include <uniexp/Events.h>


namespace ux {


#ifdef UNIEXP_MATH_FLOAT

#ifdef Coord
#undef Coord
#define Coord GLfloat
#endif
#define glVertex glVertex3f
#define glVertexv glVertex3fv
#define glColor glColor4f
#define glColorv glColor4fv
#define glTranslate glTranslatef
#define glRotate glRotatef

#else

#ifdef Coord
#undef Coord
#define Coord GLdouble
#endif
#define glVertex glVertex3d
#define glVertexv glVertex3dv
#define glColor glColor4d
#define glColorv glColor4dv
#define glTranslate glTranslated
#define glRotate glRotated

#endif


class Viewport {
protected:
  GLint x;
  GLint y;
  GLsizei width;
  GLsizei height;
public:
  Viewport(GLsizei width = 640, GLsizei height = 480, GLint x = 0, GLint y = 0);
  void setViewport(GLsizei width, GLsizei height, GLint x = 0, GLint y = 0);
  GLdouble getAspect() const;
  void glViewport() const;
};


class Perspective {
protected:
  GLdouble vFov;
  GLdouble aspect;
  GLdouble zNear;
  GLdouble zFar;
public:
  Perspective(GLdouble verticalFOV = 47.0, GLdouble aspect = 1.33,
	      GLdouble zNear = 1.0, GLdouble zFar = 100.0);
  void setPerspective(GLdouble verticalFOV, GLdouble aspect,
		      GLdouble zNear, GLdouble zFar);
  void setFOV(GLdouble vfov);
  void setAspect(GLdouble aspct);
  void setAspect(Viewport* frame);
  void setClipPlanes(GLdouble near, GLdouble far);
  void gluPerspective() const;
};


class View {
protected:
  GLdouble eye[3];
  GLdouble at[3];
  GLdouble up[3];
public:
  View(GLdouble eyeX = 10.0, GLdouble eyeY = -10.0, GLdouble eyeZ = 5.0,
       GLdouble atX = 0.0, GLdouble atY = 0.0, GLdouble atZ = 0.0,
       GLdouble upX = 0.0, GLdouble upY = 0.0, GLdouble upZ = 1.0);
  void setView(GLdouble* eye, GLdouble* at, GLdouble* up);
  void setEye(GLdouble eyeX = 10.0, GLdouble eyeY = -10.0, GLdouble eyeZ = 5.0);
  void setAt(GLdouble atX = 0.0, GLdouble atY = 0.0, GLdouble atZ = 0.0);
  void setUp(GLdouble upX = 0.0, GLdouble upY = 0.0, GLdouble upZ = 1.0);
  void direction(GLdouble* dir);
  void gluLookAt() const;
};



class Camera : public Viewport, public Perspective, public View {
public:
  void setViewport(GLsizei width, GLsizei height, GLint x = 0, GLint y = 0);
};



#define SPIN_X   1
#define SPIN_Y   2
#define SPIN_Z   4
#define SPIN_ALL 7


//class Spinner : public EventReceiver {
class Spinner {
protected:
  Coord3 angles;
  Coord3 spins;
  unsigned int axisBits;
public:
  Spinner(const Coord3& spinByAxis = Coord3(0.001, 0.001, 0.100),
	  const Coord3& initialAngles = Coord3(0.0, 0.0, 0.0));
  Spinner(const Spinner& src);
  Spinner& operator=(const Spinner& src);
  virtual ~Spinner();
  void doSpin(unsigned int axisBits = SPIN_ALL);
  void setAngles(Coord aX = 0.0, Coord aY = 0.0, Coord aZ = 0.0);
  void setSpinX(Coord ang);
  void setSpinY(Coord ang);
  void setSpinZ(Coord ang);
  void glRotate();
  // virtual int handleDispatched(const SDL_Event& event);
};


class RealTime {
  Uint32 now;
  Uint32 nextTime;
protected:
  Uint32 msPerFrame;
public:
  RealTime(float framesPerSecond = 36.0);
  void setFPS (float framesPerSecond = 36.0);
  void keepFPS();
};


}; /* namespace ux */

#endif // UX_BASE_OPENGL_H
