/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef UX_ART_VA_H
#define UX_ART_VA_H


#include <uniexp/Art_0.h>


namespace ux {


typedef std::vector<AllocC<Art_0> > _v_AA;
typedef _v_AA::iterator _iv_AA;
typedef _v_AA::const_iterator _civ_AA;
typedef _v_AA::reverse_iterator _riv_AA;
typedef _v_AA::const_reverse_iterator _criv_AA;

/** class Art_VA : public Art_0, public _v_AA
 */
class Art_VA : public Art_0, public _v_AA {
  friend std::istream& operator>>(std::istream&, Art_VA&);
  friend std::ostream& operator<<(std::ostream&, const Art_VA&);
protected:
  virtual void clear();
public:
  /** construtor padrão */
  Art_VA() : Art_0() { }
  /** construtor por cópia */
  Art_VA(const Art_VA& src);
  /** construindo com tipo e nome */
  Art_VA(const std::string& tp, const std::string& id) : Art_0(tp, id) { }
  /** constructor por autoref em Attrs */
  Art_VA(const Attrs& attrs);
  /** constructor por autoref em Attrs */
  Art_VA(AllocC<Attrs>* alloc);
  /** virtual destructor */
  virtual ~Art_VA();
  const Art_VA& operator=(const Art_VA& art);

  /** sobrescrito em subclasses */
  virtual Clonable* factory() const { return new Art_VA(); }
  /** sobrescrito em subclasses */
  virtual Clonable* clone() const { return new Art_VA(*this); }
  virtual std::istream& input(std::istream& is) { return is>>*this; }
  virtual std::ostream& output(std::ostream& os) const { return os<<*this; }

  virtual Art_0* art(size_t pos);
  virtual Art_0* art(const std::string& artName);
  virtual Art_0* sub(const std::string& artName);
  virtual Art_0* art_e(const std::string& attrsName);
  virtual Art_0* sub_e(const std::string& attrsName);

  virtual bool empty() const;
  virtual size_t size() const;

  /** push_front */
  virtual void ad_ini(Art_0* art);
  /** push_back */
  virtual void ad_fim(Art_0* art);
  /** iguala a art o filho em pos quando pos < size */
  virtual bool set_pos(Art_0* art, int pos);
  /** iguala a art o filho ref quando houver */
  virtual bool set_ref(Art_0* art, Art_0* ref);
  /** insere art na posição pos */
  virtual bool ad_pos(Art_0* art, int pos);
  /** insere art antes de ref */
  virtual bool ad_pre(Art_0* art, Art_0* ref);
  /** insere art após ref */
  virtual bool ad_post(Art_0* art, Art_0* ref);
  /** pop_fron */
  virtual void rm_pri();
  /** pop_back */
  virtual void rm_ult();
  /** remove elemento em pos */
  virtual bool rm_pos(int pos);
  /** remove o primeiro elemento.ptr == art */
  virtual bool rm_art(Art_0* art);

  virtual void xx(_fn_varr* fn, Attrs* attrs = 0);
  virtual void zx(_fn_varr* fn, Attrs* attrs = 0);
  virtual void pp(_fn_varr* preFn, _fn_varr* postFn, Attrs* attrs = 0);
  virtual void cc(_fn_varr* preChildFn, _fn_varr* postChildFn, Attrs* attrs = 0);
  virtual void ppcc(_fn_varr* preFn, _fn_varr* postFn, _fn_varr* preChildFn, _fn_varr* postChildFn, Attrs* attrs = 0);
};


}; /* namespace ux */


#endif  /* UX_ART_VA_H */

