
/* UniEXP - Universo Experimental
 * Copyright (C) 1999,2002,2003,2004,2006,2007 Silvio Almeida
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <iostream>

#include <uniexp/UniEXP_opengl.h>

using namespace std;
using namespace ux;


static UniEXP_opengl* uniexp;
static Attrs* geomAttrs;
static unsigned int should_rotate = SPIN_ALL;

/** parametros de linha de comando
   -n numTrees
   -l leafsMax
   -d deepMax
   -m maximum
   -r random
	random == 0 : simétrico e previsível
	random > 0 : seed = random
     random < 0 : random máximo
   -i inputfile
   -o outputfile
*/
static Getopts opts("n:l:d:m:r:i:o:");

static int inMainLoop = 0;


static void quitProg(int code) {
  inMainLoop = code;
  /**
   *  from SDL tutorial:
   *  Quit SDL so we can release the fullscreen mode
   * and restore the previous video settings, etc.
   */
  SDL_Quit();
  if (code != 0) {
    exit(code);
  }
}

static void handleKeys(SDL_keysym* keysym) {
  switch(keysym->sym) {
  case SDLK_p:
    cout<<"########\n"<<*uniexp<<"\n########"<<endl;
    break;
  case SDLK_ESCAPE:
    quitProg(0);
    break;
  case SDLK_SPACE:
    uniexp->doSpin((should_rotate = should_rotate ? 0 : SPIN_ALL));
    break;
  default:
    break;
  }
}

static void processEvents(void) {
  SDL_Event event;
  while(SDL_PollEvent(&event)) {
    switch(event.type) {
    case SDL_KEYDOWN:
      handleKeys(&event.key.keysym);
      break;
    case SDL_QUIT:
      quitProg(0);
      break;
    }
  }
}

static void drawScreen(void) {
  uniexp->drawInit();
  uniexp->calcGeom();
  uniexp->drawGeom();
  uniexp->drawSwap();
}

int main(int argc, char** argv) {

  uniexp = UniEXP_opengl::Instance();
  geomAttrs = uniexp->getAttrs();

  double dt, t0;
  dt = t0 = now("1d;", now());

  opts.extract(&argc, &argv);

  ///** carrega de arquivo */
  //if (opts.op('i') != "") {
  //  try {
  //    ifstream ifs(opts.op('i').c_str());
  //    if (! ifs) {
  //	throw Excc("ERRO ao ler " + opts.op('i'));
  //    }
  //    ifs>>raizArt;
  //  }
  //  catch(Excc e) {
  //    cerr<<e.txt()<<' '<<e.num()<<endl;
  //  }
  //  catch(...) {
  //    cerr<<"?????"<<endl;
  //  }
  //}

  /** parametros default da aplicação */
  int numTrees = 14;
  int leafs = 4;
  int deep = 6;
  int maxi = 4000;

  Coord conic = 22.0;
  Coord ratio = .8;
  int random = -1111;
  Coord3 randLCR = random != 0 ? Coord3(1.052, 2.9, 1.8) : Coord3(1.0, 1.0, 1.0);

  /** parametros de linha de comando */
  geomAttrs->setAttribute<int>("numTrees", ((opts.op('n') != "") ? _str_int(opts.op('n')) : numTrees));
  geomAttrs->setAttribute<int>("leafs", ((opts.op('l') != "") ? _str_int(opts.op('l')) : leafs));
  geomAttrs->setAttribute<int>("deep", ((opts.op('d') != "") ? _str_int(opts.op('d')) : deep));
  geomAttrs->setAttribute<int>("maxi", ((opts.op('m') != "") ? _str_int(opts.op('m')) : maxi));
  geomAttrs->setAttribute<Coord>("conic", ((opts.op('c') != "") ? _str_dbl(opts.op('c')) : conic));
  geomAttrs->setAttribute<Coord>("ratio", ((opts.op('h') != "") ? _str_dbl(opts.op('h')) : ratio));
  geomAttrs->setAttribute<int>("random", ((opts.op('r') != "") ? _str_int(opts.op('r')) : random));
  geomAttrs->setAttribute<Coord3>("randLCR", randLCR);


  dt = now("opts.extract", dt);

  uniexp->setupScene();
  uniexp->setupLights();
  uniexp->setupMaterials();
  uniexp->setupGeom(geomAttrs);

  dt = now("UniEXP_opengl finished setupGeom", dt);

  uniexp->createGeom();
  dt = now("UniEXP_opengl finished createGeom", dt);

  inMainLoop = 1;

  while (inMainLoop) {
    processEvents();
    if (inMainLoop) {
      drawScreen();
    }
  }

  dt = now("UniEXP_opengl drawing stopped", dt);

  if (opts.op('o') != "") {
    try {
      ofstream ofs(opts.op('o').c_str());
      if (! ofs) {
  	throw Excc("ERRO ao gravar "+opts.op('o'));
      }
      ofs<<*uniexp<<endl;
    }
    catch(Excc e) {
      cerr<<e.txt()<<' '<<e.num()<<endl;
    }
    catch(   ...) {
      cerr<<"Exception no file output ?????"<<endl;
    }
  }

  dt = now("UniEXP_opengl finished write to file "+opts.op('o'), dt);

  now("TOTAL", t0);

  return 0;
}

