###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-Need.tcl,v 1.2 2001/09/29 18:22:39 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################

# just declare this var ...
set UndernetCS_Need(DEFAULT,OP) 0

bind need - * UndernetCS:Need:EggNeed
proc UndernetCS:Need:EggNeed {channel type} {
    global UndernetCS_Need UndernetCS_Nick 

    set chan [string toupper $channel]
    set type [string toupper $type]

    if { ![UndernetCS:Need:VerifyBasicThings "$chan" "$type"] } {
        return 0
    }

    # Anti internal Need flood... (when X lag for example..)
    # Only 1 need op each 20s..
    if { [UndernetCS:Need:IsNeedFlood $chan $type] } {
	UndernetCS:PutLog "Need $type is ignored for $channel. Only 1 Need per 20 second and per need type are allowed." "NEED" 3
	return 0        
    }
    set UndernetCS_Need($chan,$type) [unixtime]

    # Verify if eggdrop isn't already authenticated
    if { [UndernetCS:IsAuth] } {
        UndernetCS:PutLog "I'am already authenticated." "NEED" 3
        # Eggdrop is so curently authenticated...
        # Verify if suspended ...
        if { [UndernetCS:IsSuspended $channel] } {
	    UndernetCS:PutLog "My access is suspended on $channel." "NEED" 3
            return
        }
        if { $type == "OP" } {
            if { ![onchan $UndernetCS_Nick $chan] } {
                UndernetCS:PutLog "NEED OP: X isn't on $chan" "NEED" 3
                return 0
            }
            # Sending op command to X
            set res [UndernetCS:Cmd:Op $channel]
        } elseif { $type == "UNBAN" } {
           set res [UndernetCS:Cmd:UnbanMe $channel]
           set res [UndernetCS:Cmd:Invite $channel]
        } else {
            # Others type can be resolved with invite ...
            set res [UndernetCS:Cmd:Invite $channel]
        }
        return $res
    }
    # Verify if eggdrop is waiting for a reply to a login request.
    if { [UndernetCS:IsWaitingForReply] } {
        # TODO verify a timeout of the request ...
        UndernetCS:PutLog "We are waiting for a reply from X." "NEED" 3
        return
    }
    # We aren't authenticated and eggdrop isn't waiting for a reply from X.
    # so we are going to start the auth procedure.
    UndernetCS:Auth:Login2X
    # We don't send now a op cmd, this events is managed when auth succ
    # is receive.
}

proc UndernetCS:Need:IsNeedFlood {chan type} {
    global UndernetCS_Need
    if { [expr [unixtime] - $UndernetCS_Need($chan,$type)] < 20 } {
	return 1
    }
    return 0
}

proc UndernetCS:Need:VerifyBasicThings {channel type} {
    global UndernetCS_Nick
    if { ![UndernetCS:IsActived] } {
        UndernetCS:PutLog "Need $type for $channel. Script is actualy disabled." "NEED" 3
        return 0
    }
    # Testing if eggdrop have an access for this channel.
    if { ![UndernetCS:HaveAccess $channel] } {
        UndernetCS:PutLog "Need $type for $channel. No access for this channel." "NEED" 3
        return 0
    }
    if { ($type == "OP") && ![onchan "$UndernetCS_Nick" "$channel"] } {
        UndernetCS:PutLog "Need $type for $channel. X are not in $channel." "NEED" 3
        return 0
    }
    UndernetCS:PutLog "Need $type for $channel" "NEED" 3
    return 1
}
### EOF ###
