###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-IO.tcl,v 1.2 2001/09/29 18:22:39 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################


# Need inidb.tcl !!!!!
######################

# UndernetCS:IO:SaveConfigFile 
#   Save Default, Global and Channel setting from 'conf'
#   if there is no arg, Save to config file who are defined
#   in UndernetCS.tcl
#   Return: Nothing.
proc UndernetCS:IO:SaveConfigFile {{conf ""}} {

    global UndernetCS_ConfFile UndernetCS_GlobalItemList
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    global UndernetCS_X UndernetCS_DebugItemList UndernetCS_Debug
    global UndernetCS_Prompt 
    
    if { $conf == "" } {
        set conf $UndernetCS_ConfFile
    }

    UndernetCS:IO:BackupFile

    UndernetCS:PutLog "Saving All settings in $conf." "GLOBAL" 3
    # Saving Default value.
    # There is default value only for channel settings.
    foreach item $UndernetCS_ChannelItemList {
        ini_write "$conf" "DEFAULT" "$item" "$UndernetCS_ChannelSetting(DEFAULT,$item)"
    }
    
    # Saving Global settings
    foreach item $UndernetCS_GlobalItemList {
        ini_write "$conf" "GLOBAL" "$item" "$UndernetCS_X($item)"
    }
    # Saving debug settings
    foreach item $UndernetCS_DebugItemList {
        ini_write "$conf" "DEBUG" "$item" "$UndernetCS_Debug($item)"
    }

    # Saving value for channel...
    foreach chan [channels] {
        set chan [string toupper $chan]
        if { [info exists UndernetCS_ChannelSetting($chan,LEVEL)] == 0 } {
            # This is probably a new channel added since the last control...
            # This proc add setting by default and save them to conf file ..
            UndernetCS:AddChan "$chan"
            continue
        }

        # Now saving settings.
        foreach item $UndernetCS_ChannelItemList  {
            ini_write "$conf" "$chan" "$item" "$UndernetCS_ChannelSetting($chan,$item)"
        }
    }
}

# UndernetCS:IO:LoadConfigFile 
#   Load Default, Global and Channel setting from 'conf'
#   if there is no arg, Save to config file who are defined
#   in UndernetCS.tcl
#   Return: Nothing.
proc UndernetCS:IO:LoadConfigFile {{conf ""}} {
    global UndernetCS_ConfFile UndernetCS_GlobalItemList
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    global UndernetCS_X UndernetCS_Prompt UndernetCS_Debug 
    global UndernetCS_DebugItemList
    
    if { $conf == "" } {
        set conf $UndernetCS_ConfFile
    }

    UndernetCS:PutLog "Load All settings in $conf." "IO" 3

    # Loading default value...
    foreach item $UndernetCS_ChannelItemList {
        set res [ini_read "$conf" "DEFAULT" "$item"]
        if { $res != "\;" } {
            set UndernetCS_ChannelSetting(DEFAULT,$item) $res
        }
    }

    # Loading Global settings
    foreach item $UndernetCS_GlobalItemList {
        set res [ini_read "$conf" "GLOBAL" "$item"]
        if { $res == "\;" } {
            # Hummm there is no value for this important things...
            # Set status of the script to disabled..
            UndernetCS:SetGlobalStatus 0
            UndernetCS:PutLog "There is no value in config file for $item !! Your config file is probably compromised." "GLOBAL" 1
            UndernetCS:PutLog "Please verify global setting with .cs list command." "GLOBAL" 1
            if { [info complete "notes"] } {
                foreach owner [userlist "+n"] {
                    storenote "UndernetCS" $owner "UndernetCS config file compromised: $item is empty. Script is now automaticaly disabled. Please verify global setting with .cs list command before enable the script." "-1"
                }
                UndernetCS:PutLog "Script is now disabled. Global(s) Owner(s) are notified." "GLOBAL" 1
            } else {
                UndernetCS:PutLog "Script is now disabled. (UndernetCS config file $item is empty)" "GLOBAL" 1
            }
        } else {
            set UndernetCS_X($item) $res
        }
    }

    # Load Debug Settings
    foreach item $UndernetCS_DebugItemList {
        set res [ini_read "$conf" "DEBUG" "$item"]
        if { $res != "\;" } {
            set UndernetCS_Debug($item) $res
        }
    }

    # Loading value for channel...
    set newchan ""
    foreach chan [channels] {
        set chan [string toupper $chan]
        UndernetCS:PutLog "read channel setting for $chan" "IO" 3
        foreach item $UndernetCS_ChannelItemList {
            # Now reading settings.
            set res [ini_read "$conf" "$chan" "$item"] 
            if { $res == "\;" } {
                UndernetCS:PutLog "$chan : $item vide" "IO" 3
                # This proc create value with default settings and load them 
                # from the config file ... 
                lappend newchan $chan
                UndernetCS:AddChan "$chan"
                break
            } else {
                set UndernetCS_ChannelSetting($chan,$item) $res
            }
        }
    }
    if { $newchan != "" } {
        UndernetCS:PutLog "New Channel(s) detected: $newchan" "IO" 3
    }
}

# UndernetCS:IO:SaveChannelSetting 
#   Save channel setting for 'channel' to the config file.
#   Return: Nothing.
proc UndernetCS:IO:SaveChannelSetting {channel} {
    global UndernetCS_ConfFile
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    global UndernetCS_Prompt 
    
    set chan [string toupper $channel]
    set conf $UndernetCS_ConfFile

    UndernetCS:PutLog "Saving  All settings in $conf for $chan." "IO" 3
    UndernetCS:IO:BackupFile    
    foreach item $UndernetCS_ChannelItemList {
        ini_write "$conf" "$chan" "$item" "$UndernetCS_ChannelSetting($chan,$item)"
    }
}

proc UndernetCS:IO:SaveGlobalSetting {} {
    global UndernetCS_ConfFile UndernetCS_GlobalItemList
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    global UndernetCS_X UndernetCS_Debug UndernetCS_DebugItemList

    set conf $UndernetCS_ConfFile
    UndernetCS:PutLog "Saving  All global settings in $conf." "IO" 3
    UndernetCS:IO:BackupFile
    # Saving Default value.
    # There is default value only for channel settings.
    foreach item $UndernetCS_ChannelItemList {
        ini_write "$conf" "DEFAULT" "$item" "$UndernetCS_ChannelSetting(DEFAULT,$item)"
    }
    # Saving Global settings
    foreach item $UndernetCS_GlobalItemList {
        ini_write "$conf" "GLOBAL" "$item" "$UndernetCS_X($item)"
    }
    # Saving debug settings
    foreach item $UndernetCS_DebugItemList {
        ini_write "$conf" "DEBUG" "$item" "$UndernetCS_Debug($item)"
    }
}

proc UndernetCS:IO:RemoveChannelSetting {channel} {
    global UndernetCS_ConfFile UndernetCS_GlobalItemList
    global UndernetCS_ChannelSetting UndernetCS_ChannelItemList 
    global UndernetCS_X

    set conf $UndernetCS_ConfFile

    UndernetCS:PutLog "Remove channel settings for $channel in $conf." "IO" 3
    ini_remove $conf [string toupper $channel] ""
}

# UndernetCS:IO:BackupConfFile
# Backing up a file to same directory, with UndernetCS_BackupExtention
proc UndernetCS:IO:BackupFile {} {
    global UndernetCS_BackupExtention UndernetCS_ConfFile
    set fichier $UndernetCS_ConfFile
    UndernetCS:PutLog "Backing up config file." "IO" 3
    if {[file exists $fichier]} {
    	file copy -force $fichier $fichier.$UndernetCS_BackupExtention
    } else {
    	UndernetCS:PutLog "Couldn't back up config file, $UndernetCS_ConfFile does not exist." "IO" 2
    }
}    
### EOF ###