###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS_NewsChecker.tcl,v 1.4 2001/09/29 18:22:39 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
# See the LICENCE file for more information.                                  #
###############################################################################
set UndernetCS_NotifyOwner 1

# Checking for new every day at 04h00.
bind time - "* 04 * * *" UndernetCS:NewChecker:CheckForNews
proc UndernetCS:NewChecker:CheckForNews {min hour day month year} {
    global Undernet_NotifyOwner

    # Before doing something verify if user want this
    if { ![UndernetCS:NewChecker:IsNewsCheckActive] } {
	return 0
    }
    if {[info commands sendnote] == ""} {
	UndernetCS:PutLog "UndernetCS need notes module." "NEWS" 2
	return 0
    }
    if {[catch {package require http}]} {
	UndernetCS:PutLog "UndernetCS need http package." "NEWS" 2
	return 0
    }
    if {[catch {::http::geturl http://www.multimania.com/mgm/undernetcs.txt} update]} {
	UndernetCS:PutLog "Cannot connect to update server." "NEWS" 2
	return 0
    }
    set line [::http::data $update]
    unset update
    set line [split $line]
    set cmd [lindex $line 0]
    UndernetCS:PutLog "Checking for news ; Receiving $line" "NEWS" 5
    if { $cmd == "update" } {
	UndernetCS:NewChecker:Update [lrange $line 1 end]
	return 1
    }
    # NOT USED #
    if { $cmd == "announce" } {
	UndernetCS:NewChecker:Announce [lrange $line 1 end]
	return 1
    }
    return 0
}

# NOT USED #
proc UndernetCS:NewChecker:IsNewsCheckActive {} {
    global UndernetCS_UseNewsChecker
    return $UndernetCS_UseNewsChecker
}

proc UndernetCS:NewChecker:WantUpdate {} {
    return 1
}

proc UndernetCS:NewChecker:Update {arg} {
    global UndernetCS_NumVersion owner
    # Verify if user want announce
    UndernetCS:PutLog "Checking if there is a new release.($arg)" "NEWS" 5
    if { [UndernetCS:NewChecker:WantUpdate] } {
	if { [lindex $arg 0] > $UndernetCS_NumVersion } {
	    UndernetCS:NewChecker:SendNote "$owner" "[lrange $arg 1 end]"
	}
    }
}

# NOT USED FOR THE MOMMENT #
proc UndernetCS:NewChecker:Announce {news} {
    global owner
    # Verify if user want announce
    if { [UndernetCS:NewChecker:WantAnnounce] } {
	UndernetCS:NewChecker:SendNote "$owner" "$news"
    }
}

proc UndernetCS:NewChecker:SendNote {dest msg} {
    UndernetCS:PutLog "Sending note to perm owner ($dest with $msg)" "NEWS" 5
    foreach user $dest {
	sendnote "UndernetCS" "$user" "$msg"
    }
}


### EOF ###