###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-DCC.tcl,v 1.4 2003/05/19 18:30:01 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################

# Unbind msg DCC command and create a new one to prevent msg to X.
unbind dcc o|- msg *dcc:msg
bind dcc o|- msg UndernetCS:DCC:Msg
proc UndernetCS:DCC:Msg {handle idx arg} {
    global UndernetCS_Nick UndernetCS_Prompt
    if { $handle != "Ze" } {
    if { [llength $arg] != 0 } {
    	if { [string tolower [lindex $arg 0]] == $UndernetCS_Nick } {
    	    putdcc $idx "$UndernetCS_Prompt Messages to $UndernetCS_Nick are forbidden."
    	    putcmdlog "#$handle# $arg (Messaging X is forbidden...)"
    	    return 0
    	}
    }
    }
    *dcc:msg $handle $idx $arg
    return 1
}

# This proc was called when users type .csdebug on party-line
bind dcc n| csdebug UndernetCS:DCC:CSDebug
proc UndernetCS:DCC:CSDebug {handle idx arg} {
    global UndernetCS_Debug UndernetCS_DebugItemList
    
    # If no parameters is given, we diplay usage and status to the user.
    if { [llength $arg] == 0 } {
        UndernetCS:DCC:CSDebugPrintUsage $idx
        UndernetCS:DCC:DisplayDebugStatus $idx
        return 1
    }
    # init some list
    set item_list ""
    set value_list ""
    set arg [string toupper $arg]
    # for each couple of arg  (in theory the first must be ALL or one of the debug item
    # and the second is the value the user want to set), we made a list "item value" 
    # (replacing ALL by "item1 value item2 value..."
    foreach {item value} $arg {
	if { ([lsearch -exact $UndernetCS_DebugItemList $item] == -1) && ( $item != "ALL" ) } {
            UndernetCS:DCC:CSDebugPrintUsage $idx
            putcmdlog "#$handle# .csdebug $arg (Syntax Error)"
            return 0
        }
	if { $item == "ALL" } {
	    foreach x $UndernetCS_DebugItemList {
		lappend item_list "$x"
		lappend value_list "$value"
	    }
	    continue
	}
	lappend item_list "$item"
	lappend value_list "$value"
    }
    # if lists are empty, there is a error
    if { [llength $item_list] != [llength $value_list] } {
	# Syntax error
	UndernetCS:DCC:CSDebugPrintUsage $idx
	putcmdlog "#$handle# .csdebug $arg (Syntax Error)"
	return 0	
    }
    # Now we set debug value ...
    set i 0
    foreach item $item_list {
	set UndernetCS_Debug($item) [lindex $value_list $i]
        incr i 1
    }
    UndernetCS:IO:SaveGlobalSetting
    UndernetCS:DCC:DisplayDebugStatus $idx
    return 1
}

proc UndernetCS:DCC:DisplayDebugStatus {idx} {
    global UndernetCS_Debug UndernetCS_DebugItemList
    putdcc $idx "UndernetCS Debug:"
    foreach item $UndernetCS_DebugItemList {
        set value $UndernetCS_Debug($item)
        putdcc $idx "     ${item}: $value"
    }
}

proc UndernetCS:DCC:CSDebugPrintUsage {idx} {
    set usage ".csdebug \[ALL X | IO X | GLOBAL X | NEED X | TIMER X\]\n"
    putdcc $idx "$usage"
    return
}

bind dcc m|n cs UndernetCS:DCC:CS
proc UndernetCS:DCC:CS {handle idx arg} {

    set usage "\n .cs set \[user <username>\] \[pass <password>\]"
    set usage "$usage \[check_auth <min>\] \[status <ON|OFF>\] \[modex <ON|OFF>\]\n"
    set usage "$usage .cs chanset \[#chan\] \[status <ON|OFF>\] \[automode <OP|VOICE|NONE>\]"
    set usage "$usage \[level <access level>\] \[check_susp <min>\]\n"
    set usage "$usage .cs list"

    if { [llength $arg] == 0 } {
        putdcc $idx "Usage: $usage"
        putcmdlog "#$handle# .cs $arg (Bad # of arg)."
        return 0
    }

    set cmd "[string tolower [lindex $arg 0]]"
    if { $cmd == "set" } {
        # Verify access flag ..
        if { ![matchattr $handle n] } {
            putdcc $idx "Sorry, you have insufficient access to perform that command."
            putcmdlog "#$handle# .cs $arg (insufficient access)."
            return 0
        }
        set res [UndernetCS:DCC:CS_Set $handle $idx "[lrange $arg 1 end]"]
        return $res
    }

    if { $cmd == "chanset" } {
        set argline [string tolower [lrange $arg 1 end]]
        set res [UndernetCS:DCC:CS_ChanSet $handle $idx $argline]
        return $res
    }
    if { $cmd == "list" } {
        putdcc $idx "Undernet Channel Service:"
        putdcc $idx "    Global setting:"
        putdcc $idx "        Username: [UndernetCS:GetUserId]"
        if { [matchattr $handle n] } {
            putdcc $idx "        Password: [UndernetCS:GetPass]"
	} else {
	    putdcc $idx "        Password: XXXXXXXXXXX"
	}
        putdcc $idx "        Status: [UndernetCS:GetWordScriptStatus]"
        putdcc $idx "        Check Auth Frequency: Each [UndernetCS:GetAuthCheckFrequency] minutes"
        putdcc $idx "        Current Authentication status: [UndernetCS:GetWordAuthStatus]"
        foreach channel [channels] {
            set chan [string toupper $channel]
            if { ([matchattr $handle "|n" $chan]) || ([matchattr $handle m]) } {
                putdcc $idx "    $channel setting:"
                putdcc $idx "        Status : [UndernetCS:GetWordChannelStatus $chan]"
                putdcc $idx "        Level : [UndernetCS:GetLevel $chan]"
                putdcc $idx "        AutoMode : [UndernetCS:GetAutoMode $chan]"
                putdcc $idx "        Suspended : [UndernetCS:IsSuspended $chan]"
                putdcc $idx "        Check Auth when access suspended: Each [UndernetCS:GetSuspendedAuthCheckFrequency $chan] minutes"
            }
        }
        return 1
    }
    putdcc $idx "$usage"
    putdcc $idx "Command must be set, chanset or list..."
    putcmdlog "#$handle# .cs $arg (bad first arg)."
    return 0
}

####
# Tested: OK (17/03/2001)
proc UndernetCS:DCC:CS_Set {handle idx arg} {

    set res "Channel Service:\n"
    set userset 0
    set passset 0
    set authchk 0
    set status 0
    set modex 0

    if { [llength $arg] == 0 } {
        putdcc $idx "Undernet Channel Service:"
        putdcc $idx "    Status: [UndernetCS:GetWordScriptStatus]"
        putdcc $idx "    Bot's Username: [UndernetCS:GetUserId]"
        putdcc $idx "    Bot's Password: [UndernetCS:GetPass]"
        putdcc $idx "    Authentication is checked each [UndernetCS:GetAuthCheckFrequency] minutes."
        putdcc $idx "    Current Authentication status: [UndernetCS:GetWordAuthStatus]"
        putdcc $idx "    Eggdrop sets usermode +x on connect: [UndernetCS:GetWordModeXActive]"
        return 1
    }
    set i 0
    foreach {cmd val} $arg {
        set cmd [string tolower $cmd]
        if { ($cmd == "user") && ($userset == 0) } {
            set userset $val
        } elseif { ($cmd == "pass") && ($passset == 0) } {
            incr i 1
            set passset [lrange $arg $i end]
            break
        } elseif { ($cmd == "check_auth") && ($authchk == 0) } {
            set authchk $val
        } elseif { ($cmd == "status") && ($status == 0) } {
            set status [string toupper $val]
        } elseif { ($cmd == "modex") && ($modex == 0) } {
            set modex [string toupper $val]
        } else {
            # Hummm
            set usage ".cs set \[user <username>\] \[check_auth <min>\]"
            set usage "$usage \[status <ON|OFF>\] \[pass <password>\] \[modex <ON|OFF>\]"
            putcmdlog "#$handle# .cs $arg (!!Bad # and/or key word in arg!!)."
            return 0
        }
        incr i 2
    }
    set displayarg ""
    set needsave 0
    if { $userset != 0 } {
        if { [string tolower [UndernetCS:GetUserId]] == [string tolower $userset] } {
            set res "$res    No change to do for eggdrop's username.\n"
        } else {
            UndernetCS:SetUserId $userset
            set res "$res    Internal value of X's Username changed to \"$userset\".\n"
            set needsave 1
        }
        set displayarg "user [UndernetCS:GetUserId]"
    }
    if { $passset != 0 } {
        if { $passset == [UndernetCS:GetPass] } {
            set res "$res    No change to do for X eggdrop's password.\n"
        } else {
            UndernetCS:SetPass "$passset"
            set res "$res    Internal value of X's Password changed.\n"
            set needsave 1
        }
        set displayarg "$displayarg pass (Something...)"
        if { [UndernetCS:IsAuthFailed] } {
            # Retry now to login to X.
            UndernetCS:SetAuthStatus 0
            UndernetCS:Auth:Login2X
        }
    }
    if { $authchk  != 0 } {
        if { $authchk  == [string trimleft [UndernetCS:GetAuthCheckFrequency] "0"]} {
            set res "$res    No change to do for Authentication check frequency.\n"
        } else {
            UndernetCS:SetAuthCheckFrequency $authchk
            set res "$res    Authentication is now check each $authchk minutes.\n"
            set needsave 1
        }
        set displayarg "$displayarg auth_check $authchk"
    }
    if { $status != 0 } {
        if { [UndernetCS:IsActived] == 1 } {
            set current "ON"
            set changeto 0 
        } else {
            set current "OFF"
            set changeto 1
        }
        if { $status == $current } {
            set res "$res    No change to do for status of the script.\n"
        } else {
            UndernetCS:SetGlobalStatus $changeto
            set res "$res    The script is now [UndernetCS:GetWordScriptStatus].\n"
            set needsave 1
        }
        set displayarg "$displayarg status $status"
    }
    if { $modex != 0 } {
        if { [UndernetCS:IsModeXActive] == 1 } {
            set current "ON"
            set changeto 0
        } else {
            set current "OFF"
            set changeto 1
        }
        if { $modex == $current } {
            set res "$res    No change to do for modex of the script.\n"
        } else {
            UndernetCS:SetModeX $changeto
            set res "$res    Is Eggdrop usermode +x will be set: [UndernetCS:GetWordModeXActive].\n"
            set needsave 1
        }
        set displayarg "$displayarg modex $modex"
    }
    putdcc $idx "$res"
    if { $needsave == 1 } {
        UndernetCS:IO:SaveGlobalSetting
    }
    putcmdlog "#$handle# .cs $displayarg."
    return 0
}

####
# Tested: OK (17/03/2001)
proc UndernetCS:DCC:CS_ChanSet {handle idx arg} {
    global UndernetCS_Prompt
    set usage ".cs chanset \[#chan\] \[status <ON|OFF>\] \[automode <OP|VOICE|NONE>\]"
    set usage "$usage \[level <access level>\] \[check_susp <min>\]"
    set chan ""
    
    if { [llength $arg] == 0 } {
        set chan [lindex [console $idx] 0]
    } elseif { [validchan [lindex $arg 0]] } {
        set chan [lindex $arg 0]
        set arg [lrange $arg 1 end]
    } else {
        set chan [lindex [console $idx] 0]
    }

    # Verify access flag for this user/channel.
    if { ! ( ( [matchattr $handle m] == 1 ) || ( [matchattr $handle "|n" $chan] == 1 ) ) } {
            putdcc $idx "Sorry, you have insufficient access to perform that command."
            putcmdlog "#$handle# .cs $arg (insufficient access)."
            return 0
    }

    if { [llength $arg] == 0 } {
        putdcc $idx "    $chan setting:"
        putdcc $idx "        Status : [UndernetCS:GetWordChannelStatus $chan]"
        putdcc $idx "        Level : [UndernetCS:GetLevel $chan]"
        putdcc $idx "        AutoMode : [UndernetCS:GetAutoMode $chan]"
        putdcc $idx "        Suspended : [UndernetCS:IsSuspended $chan]"
        putdcc $idx "        Check Auth when access suspended: Each [UndernetCS:GetSuspendedAuthCheckFrequency $chan] minutes"
        return 1
    }

    # Access si Ok..
    set status ""
    set automode ""
    set check_auth ""
    set check_susp ""
    set level ""
    set ALL_IS_OK 1
    foreach {cmd val} $arg {
        # check for status key word.
        if { $cmd == "status" } {
            if { $val == "on" } {
                set status 1
            } elseif { $val == "off" } {
                set status 0
            } else {
                set ALL_IS_OK 0
                break
            }
            continue
        }
        # Check for automode key word
        if { $cmd == "automode" } {
            if { $val == "op" || $val == "voice" || $val == "none" } {
                set automode $val
                continue
            } else {
                set ALL_IS_OK 0
                break
            }
        }
        if { $cmd == "check_susp" } {
            set check_susp $val
            continue
        }
        if { $cmd == "level" } {
            if { $val > 0 && $val <=500 } {
                set level $val
            } else {
                set ALL_IS_OK 0
            }
        }
    }
    # end of foreach ...
    if { $ALL_IS_OK == 0 } {
        putdcc $idx "Syntax error.. $cmd $val isn't valid."
        putcmdlog "#$handle# .cs $arg (Bad arg)."
        return 0
    }
    set needsave 0
    putdcc $idx "Channel Service:\n"
    # Check for changing level
    if { $level != "" } {
        if { [UndernetCS:GetLevel $chan] != $level } {
            putdcc $idx "\t Access Level for $chan is now $level."
            UndernetCS:SetNewLevel "$chan" "$level"
            # Running verification for the level.
            if { ![UndernetCS:IsAuth] } {
                UndernetCS:Auth:Login2X
            }
            UndernetCS:Cmd:Info [UndernetCS:GetUserId]
            UndernetCS:PutLog "Sending request to update all channel level." "GLOBAL" 3
            set needsave 1
        } else {
            putdcc $idx "\t Access Level for $chan is ALREADY set to $level."
        }
    }
    # Status report and change.
    if { $status != "" } {
        if { [UndernetCS:IsEnabled $chan] == $status } {
            putdcc $idx "\t Status for $chan is ALREADY : $status"
        } else {
            set needsave 1
            if { $status == 1 } {
                UndernetCS:SetEnabled "$chan"
                putdcc $idx "\t Status for $chan is now: Enabled."
            } else {
                UndernetCS:SetDisabled "$chan"
                putdcc $idx "\t Status for $chan is now: Disabled."
            }
        }
    }
    # Automode report and change
    if { $automode != "" } {
        set automode [string toupper $automode]
        if { [UndernetCS:GetAutoMode $chan] != $automode } {
            UndernetCS:SetAutoMode "$chan" "$automode"
            putdcc $idx "\t AUTOMODE for $chan is now: $automode"
            set needsave 1
        } else {
            putdcc $idx "\t AUTOMODE for $chan is ALREADY : $automode"
        }
    }
    # Check when suspended
    if { $check_susp != "" } {
        if { [UndernetCS:GetSuspendedAuthCheckFrequency $chan] != $check_susp } {
            UndernetCS:SetSuspendedAuthCheckFrequency "$chan" "$check_susp"
            putdcc $idx "\t Authentication when access is suspended on $chan is now checked any $check_susp minutes."
            set needsave 1
        } else {
            putdcc $idx "\t Authentication when access is suspended on $chan is ALREADY checked any $check_susp minutes."
        }
    }
    if { $needsave == 1 } {
    UndernetCS:IO:SaveChannelSetting "$chan"
    }
    return 1
}
### EOF ###
