###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-Cmd.tcl,v 1.2 2001/09/29 18:22:39 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################

proc UndernetCS:Cmd:Info {username} {
    set res [UndernetCS:IRC:Send2X "INFO $username"]
    if { $res } {
        return 1
    } else {
        return 0
    }
}

proc UndernetCS:Cmd:Invite {channel} {
    set RequiredLevel 100
    set chan [string toupper $channel]
    
    # Testing if eggdrop own a sufficient access level to do that.
    if { [UndernetCS:GetLevel $chan] < 100 } {
        return 0
    }
    # Level Ok ...
    set res [UndernetCS:IRC:Send2X "INVITE $chan"]
    if { $res } {
        return 1
    } else {
        return 0
    }
}
# UndernetCS:Cmd:Op
#   After check sufficient access level, sending a request
#   to X for OP 'nick'. if nick is "" X will op the eggdrop...
#   Return 1 on success, 0 otherwise.
proc UndernetCS:Cmd:Op {channel {nick ""}} {
    global UndernetCS_Nick

    set RequiredLevel 100
    set chan [string toupper $channel]
    
    # Testing if eggdrop own a sufficient access level to do that.
    if { [UndernetCS:GetLevel $chan] < $RequiredLevel } {
        return 0
    }
    # Level Ok ...
    # Verify if X is op on channel ... 
    if { [isop $UndernetCS_Nick $channel] } {
        set res [UndernetCS:IRC:Send2X "OP $chan $nick"]
        if { $res } {
            return 1
        } else {
            return 0
        }
    }
}

# UndernetCS:Cmd:DeOp
#   After check sufficient access level, sending a request
#   to X for DEOP 'nick'.
#   Return 1 on success, 0 otherwise.
proc UndernetCS:Cmd:DeOp {channel nick} {
    global UndernetCS_Nick    
    set RequiredLevel 100
    set chan [string toupper $channel]
    
    # Testing if eggdrop own a sufficient access level to do that.
    if { [UndernetCS:GetLevel $chan] < $RequiredLevel } {
        return 0
    }
    # Level Ok ...
    if { [isop $UndernetCS_Nick $channel] } {
        set res [UndernetCS:IRC:Send2X "DEOP $chan $nick"]
        if { $res } {
            return 1
        } else {
            return 0
        }
    }
}

# UndernetCS:Cmd:Ban
proc UndernetCS:Cmd:Ban {channel userhost level reason duration} {
    
    set RequiredLevel 75
    set chan [string toupper $channel]
    
    # Testing if eggdrop own a sufficient access level to do that.
    if { [UndernetCS:GetLevel $chan] < $RequiredLevel } {
        return 0
    }
    # Level Ok ...
    set res [UndernetCS:IRC:Send2X "BAN $chan $userhost $duration $level $reason"]
    if { $res } {
        return 1
    } else {
        return 0
    }
}

# UndernetCS:Cmd:Login 
#   Send an Auth request to X.
#   Return: 1 on success (of the sending request)
#           0 on failed.
proc UndernetCS:Cmd:Login {} {
    set username [UndernetCS:GetUserId]
    set pass [UndernetCS:GetPass]
    set res [UndernetCS:IRC:Send2X "LOGIN $username $pass"]
    if { $res } {
        # Changing auth status..
        UndernetCS:SetAuthStatus [unixtime]
        return 1
    } else {
        return 0
    }
}
### EOF ###