###############################################################################
#                 Undernet Channel Service Management Script                  #
###############################################################################
# $Id: UndernetCS-Auth.tcl,v 1.6 2003/05/19 18:51:34 Ze Exp $
###############################################################################
# (c) 2001 RICHARD Yann alias Ze <mgm@ifrance.com>                            #
###############################################################################

###############################################################################
# This program is distributed under the GNU General Public Licence            #
#  See the LICENCE file for more information.                                 #
###############################################################################


# UndernetCS:Auth:IsOkX
#   Return: 1 if  o The script is actived  AND
#                 o The script is enabled for 'channel'
#                 o Eggdrop have an access to X for 'channel' AND
#                 o nick = X and 'userhost' is the same that X's user@host,
#           0 otherwise.
proc UndernetCS:Auth:IsOkX {nick userhost channel debugaction} {
    
    global UndernetCS_Prompt
    # Testing if the script is actived.
    if { ![UndernetCS:IsActived] } {
        UndernetCS:PutLog "$UndernetCS_Prompt ${debugaction}. Script is actualy disabled." "AUTH" 3
        return 0
    }

    # Verify if channel exists ....
    if { ![UndernetCS:VerifyIfExists $channel] } {
	UndernetCS:PutLog "${debugaction}. settings for $channel does not exists, add this new channel" "AUTH" "3"
	UndernetCS:AddChan $channel
	# We return 0 because channel is not configured and not active by default...
	return 0
    }

    # Testing if script is enabled for channel
    if { ![UndernetCS:IsEnabled $channel] } {
        UndernetCS:PutLog "$UndernetCS_Prompt ${debugaction}. $channel is actualy disabled." "AUTH" 3
        return 0
    }

    # Testing if eggdrop have an access for this channel.
    if { ![UndernetCS:HaveAccess $channel] } {
        UndernetCS:PutLog "${debugaction}. No access for this channel." "AUTH" 3
        return 0
    }
    # Verify if it's the real X :))
    # In theory the bind with $UndernetCS_XMask do this verification ...
    if { ![UndernetCS:IsX "$nick" "$userhost"] } {
        UndernetCS:PutLog "${debugaction}. (Official Channel Service ?)." "AUTH" 3
        return 0
    }
    UndernetCS:PutLog "${debugaction}." "AUTH" 3
    return 1
}

# UndernetCS:Auth:IsOkEgg
#   Return: 1 if o 'nick' is the eggdrop AND
#                o The script is actived AND 
#                o if eggdrop have an access to X for 'channel' AND
#                o if X is on 'channel',
#           0 otherwise.
proc UndernetCS:Auth:IsOkEgg  {nick userhost channel debugaction} {
    
    global UndernetCS_Prompt botnick UndernetCS_Nick

    # first verify if it's the eggie
    if { $botnick != $nick } {
        return 0
    }
    # Verify if channel exists ....
    if { ![UndernetCS:VerifyIfExists $channel] } {
	UndernetCS:PutLog "${debugaction}. settings for $channel does not exists, add this new channel" "AUTH" 3
	UndernetCS:AddChan $channel
	# We return 0 because channel is not configured and not active by default...
	return 0
    }

    # Testing if the script is actived.
    if { ![UndernetCS:IsActived] } {
        UndernetCS:PutLog "${debugaction}. Script is actualy disabled." "AUTH" 3
        return 0
    }

    # Testing if eggdrop have an access for this channel.
    if { ![UndernetCS:HaveAccess $channel] } {
        UndernetCS:PutLog "${debugaction}. No access for this channel."  "AUTH" 3
        return 0
    }

    # Is X are on the channel ?
    if { ![onchan "$UndernetCS_Nick" "$channel"] } {
         UndernetCS:PutLog "${debugaction}.$UndernetCS_Nick are not in $channel." "AUTH" 3
        return 0
    }

    # Is eggdrop access is suspended ?
    if { [UndernetCS:IsSuspended $channel] } {
        UndernetCS:PutLog "${debugaction}. (Access is suspended for $channel)." "AUTH" 3
        return 0
    }
    UndernetCS:PutLog "${debugaction}." "AUTH" 3
    return 1
}

# -----------------------------------------------------------------------------
# ----------------------------------------------------------- EVENTS ----------
# -----------------------------------------------------------------------------

bind join - "* $UndernetCS_XMask" UndernetCS:Auth:XJoin
proc UndernetCS:Auth:XJoin {nick userhost handle channel} {
    global UndernetCS_Prompt
    set debugaction "${nick}(${userhost}) join $channel."    

    # Verify if nick is X, if script enabled and if eggie
    # have an access for this channel.
    if { ![UndernetCS:Auth:IsOkX "$nick" "$userhost" "$channel" "$debugaction"] } {
        return
    }
    if { [UndernetCS:IsSuspended $channel] } {
        UndernetCS:PutLog "${debugaction}. (Access is suspended for $channel)." "AUTH" 3
        return 0
    }
    # It is possible that X rejoin after a request from 450+... and eggdrop is auth.
    if { [UndernetCS:IsAuth] } {
        UndernetCS:PutLog "${debugaction}. We are already Authenticated." "AUTH" 3
        return 0
    }
    UndernetCS:Auth:Login2X 
}

bind REJN - "* $UndernetCS_XMask" UndernetCS:Auth:XSplitRejoin
proc UndernetCS:Auth:XSplitRejoin {nick userhost handle channel} {
    global UndernetCS_Prompt
    set debugaction "${nick}(${userhost}) join (After a split) $channel."    

    # Verify if nick is X, if script enabled and if eggie
    # have an access for this channel.
    if { ![UndernetCS:Auth:IsOkX "$nick" "$userhost" "$channel" "$debugaction"] } {
        return
    }
    if { [UndernetCS:IsSuspended $channel] } {
        UndernetCS:PutLog "${debugaction}. (Access is suspended for $channel)." "AUTH" 3
        return 0
    }
    UndernetCS:Auth:Login2X
}

bind part - "* $UndernetCS_XMask" UndernetCS:Auth:XPart
proc UndernetCS:Auth:XPart {nick userhost handle channel {msg ""}} {
    set debugaction "${nick}(${userhost}) has left $channel."

    # We verify if X is already present in other channel and we consider
    # if X not present that eggdrop aren't authenticated now.
    foreach chan [channels] {
        if { $chan == $channel } {
            continue
        }
        if { [onchan $nick $chan] } {
            return
        }
    }
    # X isn't on others channels..
    # .. so we are not auth now ..
    UndernetCS:SetAuthStatus 0
}

bind SIGN - "* $UndernetCS_XMask" UndernetCS:Auth:XQuit
proc UndernetCS:Auth:XQuit {nick userhost handle channel reason} {
    set debugaction "${nick}(${userhost}) has quit IRC $channel."
    # X quit IRC .. so we are not auth now ..
    UndernetCS:SetAuthStatus 0
}

bind SPLT - "* $UndernetCS_XMask" UndernetCS:Auth:XSplit
proc UndernetCS:Auth:XSplit {nick userhost handle channel} {
   set debugaction "${nick}(${userhost}) has gets netsplit $channel."
    
    # X quit IRC .. so we are not auth now ..
    UndernetCS:SetAuthStatus 0
}

bind evnt - init-server UndernetCS:Auth:ServerConnect
proc UndernetCS:Auth:ServerConnect {type} {
    global UndernetCS_Prompt UndernetCS_X botnick
    UndernetCS:PutLog "I'am just connected to an IRC server..." "AUTH" 3
    # Send a login request now without know if X is on IRC...
    UndernetCS:Cmd:Login
    UndernetCS:PutLog " Sending a login request to Channel Service." "AUTH" 3
    if { $UndernetCS_X(MODEX) == 1 } { 
      putserv "MODE $botnick +x"
    }
}

bind evnt - disconnect-server UndernetCS:Auth:ServerDisconnect
proc UndernetCS:Auth:ServerDisconnect {type} {
    global UndernetCS_Prompt 
    # We are disconnected.. so we are not authenticated now ..
    UndernetCS:PutLog "I'am just disconnected from IRC." "AUTH" 3
    UndernetCS:SetAuthStatus 0
}

bind part - * UndernetCS:Auth:TEggPart
proc UndernetCS:Auth:TEggPart {nick userhost handle channel msg} {
    # Parsing nick userhost handle and channel for [] and {} to add \...
    set nick [UndernetCS:Parse $nick]
    set handle [UndernetCS:Parse $handle]
    set userhost [UndernetCS:Parse $userhost]
    set channel [UndernetCS:Parse $channel]
    set msg [UndernetCS:Parse $msg]
    set cmd "UndernetCS:Auth:EggPart $nick $userhost $handle $channel \"$msg\""
    set t [utimer 10 $cmd]
    UndernetCS:PutLog "EggPartTimer --> $t" "AUTH" 4    
}

proc UndernetCS:Auth:EggPart {nick userhost handle channel msg} {
    global UndernetCS_Nick

    set debugaction "${nick}(${userhost}) has left $channel. <-- It's ME?"

    if { ![validchan $channel] } {
        # This chan is just remove from eggdrop ..
        UndernetCS:PutLog "$debugaction ; This chan isn't monitored, remove it from UndernetCS" "AUTH" 3
        UndernetCS:RemChan $channel
    } else {
	if { ![UndernetCS:Auth:IsOkEgg "$nick" "$userhost" "$channel" "$debugaction"] } {
	    return
	}
        UndernetCS:PutLog "$debugaction ; this chan is probably +inactive" "AUTH" 3
        foreach chan [channels] {
            if { $chan == $channel } {
                continue
            }
            if { [onchan $UndernetCS_Nick $chan] } {
                UndernetCS:PutLog "$debugaction ; X is present on $chan so we are already authenticated." "AUTH" 3
                return
            }
        }
        # X isn't on others channels..
        # .. so we are not auth now ..
        UndernetCS:PutLog "$debugaction ; X isn't present on others channel, we are unauthenticated." "AUTH" 3
        UndernetCS:SetAuthStatus 0
    }
}

bind join - * UndernetCS:Auth:EggJoinTimer
proc UndernetCS:Auth:EggJoinTimer {nick userhost handle channel} {

    if { [UndernetCS:VerifyIfExists $channel] } {
        # Parsing nick userhost handle and channel for [] and {} to add \...
        set nick [UndernetCS:Parse $nick]
        set handle [UndernetCS:Parse $handle]
        set userhost [UndernetCS:Parse $userhost]
        set channel [UndernetCS:Parse $channel]
        set cmd "UndernetCS:Auth:EggJoin \"$nick\" \"$userhost\" \"$handle\" \"$channel\""
        set t [utimer 8 $cmd]
        UndernetCS:PutLog "EggJoinTimer --> $t ($nick $handle $userhost $channel)" "AUTH" 4
    } else {
        # This is a new channel !
        UndernetCS:PutLog "New channel detected: $channel" "AUTH" 3
        UndernetCS:AddChan "$channel"
    }
}

proc UndernetCS:Auth:EggJoin {nick userhost handle channel} {
    global UndernetCS_Prompt

    set debugaction "${nick}(${userhost}) join $channel. <-- It's ME?"

    if { ![UndernetCS:Auth:IsOkEgg "$nick" "$userhost" "$channel" "$debugaction"] } {
        return
    }

    # Verify if eggdrop isn't already authenticated
    if { [UndernetCS:IsAuth] } {
        UndernetCS:PutLog "I'am already authenticated." "AUTH" 3
        # Eggdrop is so curently authenticated...
        # Verify if suspended ...
        if { [UndernetCS:IsSuspended $channel] } {
            UndernetCS:PutLog "My access is suspended on $channel." "AUTH" 3
            return
        }
        # Verify if AUTOMODE is on OP and if not sending op command to X
        if { ![UndernetCS:IsAutoModeOp $channel] } {
            # Sending op command to X
            set res [UndernetCS:Cmd:Op $channel]
            # TODO use the result ....
        }
        return
    }
    # Verify if eggdrop is waiting for a reply to a login request.
    if { [UndernetCS:IsWaitingForReply] } {
        # TODO verify a timeout of the request ...
        return
    }
    # We aren't authenticated and eggdrop isn't waiting for a reply from X.
    # so we are going to start the auth procedure.
    UndernetCS:Auth:Login2X
    # We don't send now a op cmd, this events is managed when auth succ
    # is receive.
}

proc UndernetCS:Auth:IsOkX_Notice {nick userhost dest debugaction} {
    global botnick
    # Testing if dest is eggdrop.
    if { $dest != $botnick } {
        return
    }

    # Verify if the script is active
    if { ![UndernetCS:IsActived] } {
        UndernetCS:PutLog "${debugaction}. Script is actualy disabled." "AUTH" 3
        return 0
    }

    # Verify if it's the real X :))
    if { ![UndernetCS:IsX "$nick" "$userhost"] } {
        UndernetCS:PutLog "${debugaction}. (Official Channel Service ?)." "AUTH" 3
        return 0
    }
    UndernetCS:PutLog "${debugaction}." "AUTH" 3
    return 1
}

bind notc - "AUTHENTICATION SUCCESSFUL as*" UndernetCS:Auth:XNotice_AuthSucc
proc UndernetCS:Auth:XNotice_AuthSucc {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (auth succ)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    set textnotice [string toupper $text]
    
    # We receive a notice from X who said, that auth is succ, paranoia mode:
    # we verify if username is the one that are saved in this script :)
    if { [string tolower [lindex $textnotice 3]] != [string tolower [UndernetCS:GetUserId]] } {
        set alert "!! I want this :Auth succ as [UndernetCS:GetUserId] !!"
        UndernetCS:PutLog "${debugaction}. $alert" "AUTH" 3
        UndernetCS:SetAuthStatus 0
        UndernetCS:Auth:Login2X
        return
    }
    UndernetCS:SetAuthStatus 1
}

bind notc - "Sorry, You are already authenticated as*" UndernetCS:Auth:XNotice_AlreadyAuth
proc UndernetCS:Auth:XNotice_AlreadyAuth {nick userhost handle text dest} {
    global UndernetCS_Prompt     
    set debugaction "Received notice from ${nick}(${userhost}): $text (already auth)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    set textnotice [string toupper $text]
    
    # We receive a notice from X who said, we are already auth, paranoia mode:
    # we verify if username is the one that are saved in this script :)
    if { [string tolower [lindex $textnotice 6]] != [string tolower [UndernetCS:GetUserId]] } {
        set alert "!! I want this : as [UndernetCS:GetUserId] !!"
        UndernetCS:PutLog "${debugaction}. $alert" "AUTH" 3
        UndernetCS:Auth:Login2X 
        return
    }
    # We are auth ..
    UndernetCS:SetAuthStatus 1
}

bind notc - "Sorry, You must be logged in to use this command*" UndernetCS:Auth:XNotice_NotLogged
proc UndernetCS:Auth:XNotice_NotLogged {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (not logged)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    # We are not auth ..
    UndernetCS:SetAuthStatus 0
    # Sending login command ..
    UndernetCS:Auth:Login2X 
}

bind notc - "You are not authorised with me anymore*" UndernetCS:Auth:XNotice_DeAuth
proc UndernetCS:Auth:XNotice_DeAuth {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (Annother user are auth with my username!)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    # We are not auth ..
    UndernetCS:SetAuthStatus 0
    # Sending login command ..
    UndernetCS:Auth:Login2X 
}


bind notc - "AUTHENTICATION FAILED as*" UndernetCS:Auth:XNotice_AuthFailed
proc UndernetCS:Auth:XNotice_AuthFailed {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (auth failed)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    set textnotice [string toupper $text]
    # We receive a notice from X who said, auth failed as ***, paranoia mode:
    # we verify if username is the one that are saved in this script :)
    if { [string tolower [lindex $textnotice 3]] != [string tolower [UndernetCS:GetUserId]] } {
        set alert "!! I want this : as [UndernetCS:GetUserId] !!"
        UndernetCS:PutLog "${debugaction}. $alert" "AUTH" 3
        # Send another
        UndernetCS:Auth:Login2X
        return
    }
    # Auth failed ...
    UndernetCS:SetAuthStatus -1
    UndernetCS:SetGlobalStatus 0
}

bind notc - "Your access on*has been suspended." UndernetCS:Auth:XNotice_Suspended
proc UndernetCS:Auth:XNotice_Suspended {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (Access suspended)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    set textnotice [string toupper $text]
    set channel [lindex $textnotice 3]
    # set that access for this channel is suspended..
    UndernetCS:SetSuspended $channel 1
}

bind notc - "Channels:*" UndernetCS:Auth:XNotice_ReceiveChannelLevel
proc UndernetCS:Auth:XNotice_ReceiveChannelLevel {nick userhost handle text dest} {
    global UndernetCS_Prompt 
    set debugaction "Received notice from ${nick}(${userhost}): $text (Reply for Update Channel Level)"
    if { ![UndernetCS:Auth:IsOkX_Notice "$nick" "$userhost" "$dest" "$debugaction"] } {
        return
    }
    set text [lrange $text 1 end]
    set needsave 0
    set chanlist ""
    foreach {chan level} $text {
        set chan [string toupper $chan]
        set level [string trim [string trim [string trim $level ","] ")"] "("]
        if { [validchan $chan] } {
            lappend chanlist "$chan"
            if { [UndernetCS:GetLevel $chan] != $level } {
                UndernetCS:PutLog "New Level for $chan detected: $level" "AUTH" 3
                set needsave 1
                UndernetCS:SetNewLevel $chan $level
                UndernetCS:PutLog "Level for $chan is ok: $level" "AUTH" 3
            }
        } else {
            UndernetCS:PutLog "We have an access on unknow channel: $chan $level" "AUTH" 3
        }
    }

    # Now verify if some channel are enabled without eggdrop have access.
    foreach chanz [channels] {
        if { [UndernetCS:IsEnabled $chanz] } {
            set chanz [string toupper $chanz]
            if { [lsearch -exact $chanlist $chanz] == -1 } {
                # This channel is enabled and have no access .... 
                # Automaticaly set level to 0 (and so disabled this channel)
                UndernetCS:SetNewLevel $chanz 0
                UndernetCS:PutLog "$chanz is now disabled (No access for this channel detected)." "AUTH" 3
                set needsave 1
            }
        }
    }
    if { $needsave } {
        UndernetCS:IO:SaveConfigFile
    }
}


bind mode - * UndernetCS:Auth:OnEggDeOp
proc UndernetCS:Auth:OnEggDeOp {nick userhost handle channel modech victim} {
    global botnick UndernetCS_Prompt UndernetCS_Nick

    if { $modech != "-o" } { return }
    set channel [string toupper $channel]
    if { [string tolower $victim] == [string tolower $botnick] } {
	set debugaction "$nick (${handle}) deop me on $channel"
	# Verify if channel exists ....
	if { ![UndernetCS:VerifyIfExists $channel] } {
	    UndernetCS:PutLog "${debugaction}. settings for $channel does not exists, add this new channel" "AUTH" 3
	    UndernetCS:AddChan $channel
	    # We return 0 because channel is not configured and not active by default...
	    return 0
	}
	# Testing if the script is actived.
	if { ![UndernetCS:IsActived] } {
	    UndernetCS:PutLog "${debugaction}. Script is actualy disabled." "AUTH" 3
	    return 0
	}
	# Testing if eggdrop have an access for this channel.
	if { ![UndernetCS:HaveAccess $channel] } {
	    UndernetCS:PutLog "${debugaction}. No access for this channel."  "AUTH" 3
	    return 0
	}
	# Is X are on the channel ?
	if { ![onchan "$UndernetCS_Nick" "$channel"] } {
	    UndernetCS:PutLog "${debugaction}.$UndernetCS_Nick are not in $channel." "AUTH" 3
	    return 0
	}
	# Is eggdrop access is suspended ?
	if { [UndernetCS:IsSuspended $channel] } {
	    UndernetCS:PutLog "${debugaction}. (Access is suspended for $channel)." "AUTH" 3
	    return 0
	}
        # Eggdrop was just deopped by $nick..
        if { $handle == "*" } {
            # URGENT: This user is unkown by the eggdrop.
            # UndernetCS:Auth:IamDeopedByUnknowUser $channel $nick
            UndernetCS:Cmd:Op "$channel"
            UndernetCS:Cmd:DeOp "$channel" "$nick"
        } elseif { ([matchattr $handle o|]) || ([matchattr $handle f|]) } {
            # Global User
            # UndernetCS:Auth:IamDeopedByGlobalUser $channel $handle
        } elseif { [matchattr $handle |n $channel] } {
            # Channel Owner
            # UndernetCS:Auth:IamDeopedByChannelOwner $channel $handle
        } elseif { [matchattr $handle b] } {
            # Global Bot
            # UndernetCS:Auth:IamDeopedByGlobalBot $channel $handle
            UndernetCS:Cmd:Op "$channel"
        } elseif { [matchattr $handle |b $channel] } {
            # Channel Bot
            # UndernetCS:Auth:IamDeopedByChannelBot $channel $handle
            UndernetCS:Cmd:Op "$channel"
        } else {
            # User is perhaps channel op/master or autokick/deop etC...
            # UndernetCS:Auth:IamDeopedByOtherUser $channel $handle
            UndernetCS:Cmd:Op "$channel"
            UndernetCS:Cmd:DeOp "$channel" "$nick"
        }
    }
}

# ------------------------------------------------------ End of events proc ---
# -----------------------------------------------------------------------------

# -----------------------------------------------------------------------------
# ---------------------------------------------------- Timer Management--------
# -----------------------------------------------------------------------------
proc UndernetCS:Auth:AuthTimeChecker {min hour day month year} {
    global UndernetCS_Prompt 
    if { [UndernetCS:IsAuth] == 1 } {
        # We are already authenticated...
        UndernetCS:PutLog "Authentication checker: We are already Authenticated." "AUTH" 3
        return 0
    }

    set timerlastsend [UndernetCS:IsWaitingForReply]
    if { $timerlastsend == 0 } {
        # We are not auth and we are not waiting for reply ... sending auth request now !
        UndernetCS:PutLog "Authentication checker: We are not auth and not waiting for a reply. Sending an auth request now!" "AUTH" 3
        UndernetCS:Auth:Login2X
        return 0
    }
    # Calculating if the last request is recent..
    # if more than 3 minutes we resend a login request ...
    set dif [expr $timerlastsend - [unixtime]]
    if { $dif > 179 } {
        UndernetCS:PutLog "Authentication checker: Waiting for a reply since more than 2 min.. Sending a new one." "AUTH" 3
        UndernetCS:Cmd:Login
        return 1
    }
    return 0
}

# -----------------------------------------------------------------------------
# --------------------------------------------------------- Sub Proc ----------
# -----------------------------------------------------------------------------
# UndernetCS:Auth:Login2X 
#   Send an command to authenticate the eggdrop to X.
#   the command is not send, if we have already send this command and
#   eggdrop waiting for a reply, and if the last login request is FAILED.
#   WARNING: in this command we don't verify if eggdrop is already auth to X
#   Return: 1 if command if send
#           0 if not.
proc UndernetCS:Auth:Login2X {} {
    global UndernetCS_Prompt UndernetCS_Nick
    # Verify if we are waiting for a reply to an auth command
    if { [UndernetCS:IsWaitingForReply] } {
        # Verifier le timeout ?
        UndernetCS:PutLog "An authentication procedure is under processing." "AUTH" 3
        return 0
    }
    
    # Verify if last anwser to auth request was "FAILED".
    if { [UndernetCS:IsAuthFailed] } {
        UndernetCS:PutLog "The last try to auth failed. Script is so disabled." "AUTH" 3
        return 0
    }
    # Verify if X is at least on one channel, so verify if he is online.
    # If not on line we don't send a login request. In the future we will
    # use the ISON irc command to know if X is on IRC.
    set ison 0
    foreach chan [channels] {
        if { [onchan $UndernetCS_Nick $chan] } {
            set ison 1
        }
    }
    if { $ison == 1 } {
        set res [UndernetCS:Cmd:Login]
        return $res
    } else {
        UndernetCS:PutLog "X isn't on any channel who are monitored. So we don't send a login request." "AUTH" 3
    }
    return 0
}

bind raw - 401 UndernetCS:Auth:RAW401
proc UndernetCS:Auth:RAW401 {from keyword args} {
    global UndernetCS_Prompt UndernetCS_Nick
    set args [split $args]
    set nick [string tolower [string index [lindex $args 1] 0]]
    if { [string tolower $nick] == [string tolower $UndernetCS_Nick] } {
        UndernetCS:PutLog "RAW 401: X is not on IRC." "AUTH" 3
    }
    UndernetCS:SetAuthStatus 0
    UndernetCS:PutLog "Received RAW 401: $args ($nick)" "AUTH" 3
    return 0
}

### EOF ###
