/*
 * Copyright (C) 2000 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Generate a machine readable file mapping each UTF-16 character to
 * its unaccented equivalent using the libunac library. The output may
 * then be compared with the output of builder -reference. Both must be
 * equal (ignoring space differences).
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "unac.h"

int main() {
  unsigned int c;
  unsigned short* p;
  int l;
  for(c = 0; c <= 0xFFFF; c++) {
    unac_char_utf16(c, p, l);
    printf("%04X", c);
    if(l == 0) {
      printf("\n");
    } else {
      int i;
      printf(" => ");
      for(i = 0; i < l; i++) {
	printf("%04X ", p[i]);
      }
      printf("\n");
    }
  }

  {
    char* out = 0;
    size_t out_length = 0;
    unac_string("ISO-8859-1", "t", 3, &out, &out_length);
    if(out_length != 3) {
      fprintf(stderr, "out_length == %d instead of 3\n", out_length);
      exit(1);
    }
    if(memcmp("ete", out, out_length)) {
      fprintf(stderr, "out == %.*s instead of ete\n", out_length, out);
      exit(1);
    }
  }
  return 0;
}
