/*
 * Copyright (C) 2000 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include "unac.h"

int main(int argc, char** argv) {
  const char* charset = argv[1];
  const char* string = argv[2];
  const char* expected = argv[3];

  char* unaccented = 0;
  int unaccented_length = 0;

  if(argc < 2 || argc > 4) {
    fprintf(stderr, "usage: unaccent <charset> [<string>] [<expected>]\n\
\tRead input from stdin and remove accents from each line.\n\
\tIf <string> is provided, remove accents from <string> knowing\n\
\tthat <string> is encoded using <charset>. If <expected> is provided, \n\
\tcompare the result and exit on error if they are not equal. \n\
\tThe unaccented result is always output on stdout.\n");
    exit(1);
  }

  if(argc == 2) {
#define BUFFER_SIZE 10240
    char buffer[BUFFER_SIZE];
    while(fgets(buffer, BUFFER_SIZE, stdin)) {
      if(unac_string(charset, buffer, strlen(buffer), &unaccented, &unaccented_length) < 0) {
	perror("unac_string");
	exit(1);
      }
      printf("%.*s", unaccented_length, unaccented);
    }
  } else {
    if(unac_string(charset, string, strlen(string), &unaccented, &unaccented_length) < 0) {
      perror("unac_string");
      exit(1);
    }

    printf("%.*s\n", unaccented_length, unaccented);

    if(argc == 4) {
      if(unaccented_length != strlen(expected) ||
	 !memcpy(unaccented, expected, unaccented_length)) {
	free(unaccented);
	return 1;
      }
    }
  }
  free(unaccented);

  return 0;
}
