/*
 * Copyright (C) 2000, 2001 Loic Dachary, Andreas Hochsteger
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/* $Id: php4_unac.c,v 1.2 2000/12/23 10:52:54 loic Exp $ */

#if USE_PHP == 4

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"

#include "unac.h"

static PHP_FUNCTION(unac_string);
static PHP_MINIT_FUNCTION(unac);
static PHP_MSHUTDOWN_FUNCTION(unac);
static PHP_FUNCTION(unac_string);
static PHP_MINFO_FUNCTION(unac);
zend_module_entry *get_module(void);

/* Every user visible function must have an entry in unac_functions[].
*/
function_entry unac_functions[] = {
	PHP_FE(unac_string,	NULL)
	{NULL, NULL, NULL}	/* Must be the last line in unac_functions[] */
};

zend_module_entry unac_module_entry = {
	"unac",
	unac_functions,
	PHP_MINIT(unac),
	PHP_MSHUTDOWN(unac),
	NULL,
	NULL,
	PHP_MINFO(unac),
	STANDARD_MODULE_PROPERTIES
};

ZEND_GET_MODULE(unac)

static PHP_MINIT_FUNCTION(unac)
{
	return SUCCESS;
}

static PHP_MSHUTDOWN_FUNCTION(unac)
{
	return SUCCESS;
}

static PHP_MINFO_FUNCTION(unac)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "unac support", "enabled");
	php_info_print_table_end();
	php_info_print_box_start(0);
	PUTS("Strip accents from a string, based on version "UNAC_VERSION".
Usage is unac_string(charset, string) that returns the string
argument without accents. 
Example: unac_string(\"iso-8859-1\", \"t\") -> \"ete\".
");
	php_info_print_box_end();
}

/* {{{ proto int unac_string(string charset, string in)
    */
static PHP_FUNCTION(unac_string)
{
	zval **charset, **in;
	char *str = 0;
	int str_length = 0;

	if (ZEND_NUM_ARGS() != 2 || zend_get_parameters_ex(2, &charset, &in) == FAILURE){
		WRONG_PARAM_COUNT;
	}

	convert_to_string(*charset);
	convert_to_string(*in);

	if(unac_string((*charset)->value.str.val,
		       (*in)->value.str.val, (*in)->value.str.len,
		       &str, &str_length) < 0) {
	  zend_error(E_WARNING, "unac_string: failed %s", strerror(errno));
	  RETURN_FALSE;
	}

	RETURN_STRINGL(str, str_length, 1 /* duplicate */);
}
/* }}} */

#endif /* USE_PHP == 4 */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
