/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   utils.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains some global "utils type" function such as custom
 *              random functions for instance
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <stdlib.h>
#include <ClanLib/display.h>

#include "utils.h"
#include "debug.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * returns a random number between 0 and scale-1
 */
int U61_Utils::random(int scale)
{
  int temp;

#ifdef U61_MSVC
  temp=rand();
#else
  temp=::random();
#endif

  if (temp<0)
    {
      temp=-temp;
    }

  return (temp%scale);
}

/*--------------------------------------------------------------------------*/
/*
 * Sets a videomode
 * This function simply calls ClanLib's set_videomode function with several
 * parameters, so that it only fails in critical cases
 */
bool U61_Utils::set_videomode(int w,int h,bool fullscreen)
{
  bool ok=false;

  if (!ok)
    {
      try 
	{
	  CL_Display::set_videomode(w,h,16,fullscreen);
	  ok=true;
	}
      catch (CL_Error e)
	{
          try
	    {
	      CL_Display::set_videomode(w,h,16,!fullscreen);
	      ok=true;
	    }
	  catch (CL_Error e)
	    {
	      try
		{
		  CL_Display::set_videomode(w,h,8,fullscreen);
		  ok=true;
		}
	      catch (CL_Error e)
		{
		  try
		    {
		      CL_Display::set_videomode(w,h,8,!fullscreen);
		      ok=true;
		    }
		  catch (CL_Error e)
		    {
		      U61_LOG_WARNING("Invalid video mode: w="<<w
				      <<" h="<<h
				      <<" fullscreen="<<fullscreen);
		    }
		}
	    }
	}
    }

  return ok;
}
