/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   time.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to manage time. it provides a "game time" which supports
 *              pauses, resets etc... and a system time which never stops
 *              running and is used for animations
 */


#ifndef INC_U61_TIME
#define INC_U61_TIME

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_TIME_ONE_SECOND 100

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Time
{
public:
    static void reset(int unsigned time=0);
    static unsigned int for_event();
    static unsigned int for_logic();
    static unsigned int for_effect();
    static void alter(int delta);   
    static void speed_up();   
    static void slow_down();   
    static bool is_logic_needed();   
    static void acknowledge_logic();   
    static bool is_display_needed(int fps);   
    static void acknowledge_display();   
    static void pause();   
    static void resume();   
    static bool is_paused();   
    static void idle();
    
protected:
    static int reset_offset;
    static int alter_offset;
    static int pause_offset;
    static unsigned int start_pause_time;
    static bool paused;
    static unsigned int last_for_event;
    static unsigned int last_for_logic;    
    static unsigned int last_for_display;

    static int system_time();
};

#endif




