/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        menuinput.cpp
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: February 2000
 * description: input class which handles menu evemts
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "menuinput.h"
#include "inputmonitor.h"
#include "time.h"
#include "debug.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_MENUINPUT_MOUSE_DELAY       50
#define U61_MENUINPUT_REPEAT_FIRST      50
#define U61_MENUINPUT_REPEAT_STANDARD   15

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a menu input object
 */ 
U61_MenuInput::U61_MenuInput() : U61_Input(U61_INPUTMONITOR_NUM_KEYS)
{
  init();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a menu input object
 */ 
U61_MenuInput::~U61_MenuInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * initializations of the menu keys
 */
void U61_MenuInput::init()
{
  int i;
  U61_Key key;

  mouse_last_fired=-1;
  mouse_y=-1;

  for (i=0;i<U61_INPUTMONITOR_NUM_KEYS;++i)
    {
      key.init(i,i,U61_MENUINPUT_REPEAT_FIRST,U61_MENUINPUT_REPEAT_STANDARD);
      set_key(i,key);
    } 
}

/*--------------------------------------------------------------------------*/
/*
 * Polls the mouse for basic clicks
 */
void U61_MenuInput::poll_mouse()
{
  if (CL_Mouse::middle_pressed() ||
      CL_Mouse::left_pressed() ||
      CL_Mouse::right_pressed())
    {
      mouse_y=CL_Mouse::get_y();
    }
  else
    {
      mouse_y=-1;
    }

  /*
   * For now this mouse support just sucks, so I have disabled it,
   * so that people do not think the GUI is buggy. It's better for
   * everyone to use the keyboard only for now...
   */
  mouse_y=-1;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the y position of the mouse if it has been clicked, or -1
 */
int U61_MenuInput::get_mouse_y()
{
  int result=-1;
  int time;

  time=U61_Time::for_effect();
  if (time-mouse_last_fired>U61_MENUINPUT_MOUSE_DELAY)
    {
      mouse_last_fired=time;
      result=mouse_y;
    }

  return result;
}
