/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   input.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class is used to retrieve information from the keyboard
 *              it is basically an array of keys which can be polled
 *              the interesting point is that an input object may listen
 *              only a reduced number of keys (for instance the keys
 *              associated to a player). this way keys are automatically
 *              sorted, one can say player 1 is associated to keys 
 *              'A' 'B' and 'C' and be sure that this does not interfere 
 *              with other players input
 */


#ifndef INC_U61_INPUT
#define INC_U61_INPUT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "key.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_INPUT_MAX_KEYS      256

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Input
{ 
public:
    U61_Input(int size);
    ~U61_Input();
 
    void set_key(int index,U61_Key key);

    void poll(int time);
    void reset();
    bool empty();
    U61_Event get();
protected:
    std::list<U61_Event> queue;
    U61_Key *keys; 
    int keys_size;
};

#endif
