/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   global.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a class which contains static objects which are meant to
 *              be used as global data. for instance, the config and data
 *              are stored in this class. it's interesting to have
 *              this class static and keep config and data not static,
 *              for this way it's possible to load several config/data set
 *              and then choose to use one or another
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "global.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * the config object contains the config of the game, that's it!
 */
U61_Config U61_Global::config;

/*--------------------------------------------------------------------------*/
/*
 * the data object contains the data of the game, that's it!
 */
U61_Data U61_Global::data;

/*--------------------------------------------------------------------------*/
/*
 * it can be usefull to have the game as a global object 
 * For instance when a protocol wants to start/stop the game
 */
U61_Game U61_Global::game;

/*--------------------------------------------------------------------------*/
/*
 * it can be usefull to have the layout as a global object 
 * In fact it is mostly used to get next/prev players from the map objects
 */
U61_Layout U61_Global::layout;

/*--------------------------------------------------------------------------*/
/*
 * The buffers of the RemoteScript class are declared global
 * because it was quite tricky to handle them as arguments
 * since the script has to be saved at the end of the game,
 * when the ClientProtocol class (which reads the remote
 * script) has been deleted.
 */
U61_RemoteScript U61_Global::remote_script;

/*--------------------------------------------------------------------------*/
/*
 * This object is a wrapper placed over ClanLib's API, it's responsible
 * for setting hooks on the keyboard press/release functions and maintain
 * a database of pressed keys.
 */
U61_InputMonitor U61_Global::input_monitor;

/*--------------------------------------------------------------------------*/
/*
 * This object holds all the scores for the current game. Scores have been
 * separated from the player/map objects since it easier this way to pass
 * the information to the menu which displays the score.
 */
U61_Score U61_Global::score;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/
