/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   eventcopy.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: abstract class. its subclasses may be used to transmit
 *              information to other players. basically, a map/player is
 *              associated to an eventcopy instance. all events are send to
 *              the eventcopy, which if and to who the events should be
 *              transmitted
 */

#ifndef INC_U61_EVENTCOPY
#define INC_U61_EVENTCOPY

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "event.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_EventCopy
{ 
 public:
  U61_EventCopy(int player_id);
  virtual ~U61_EventCopy();

  virtual void flush();
  void clear();
  bool empty();
  void put(U61_Event);
 protected:
  int dummy_counter;

  int player;
  std::list<U61_Event> queue;
};

#endif
