/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   config.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the config object holds all the values which are stored
 *              on the HD between two game sessions. it would for instance
 *              store the player names and key settings
 *              it basically provides functions to load and save all the
 *              game parameters, and makes these parameters usable by any
 *              other class.
 *              it also provides some function which help handling game
 *              settings in general
 */

#ifndef INC_U61_CONFIG
#define INC_U61_CONFIG

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <stdio.h>
#include <ClanLib/core.h>

#include "const.h"
#include "playerconfig.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_CONFIG_NB_PLAYERS 4

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Config
{
 public:
  U61_Config();
  ~U61_Config();

  void reset();
  bool read();
  bool write();
  bool load_script();

  int launch_count;

  char data_dir[U61_CONST_STRING_SIZE];
  char script_dir[U61_CONST_STRING_SIZE];
  char data_file[U61_CONST_STRING_SIZE];
  char script_file[U61_CONST_STRING_SIZE];

  bool fullscreen;

  char server_id[U61_CONST_STRING_SIZE];
  int network_port;
  int network_channel;
    
  int initial_speed;
  int acceleration;
  int curse_delay;

  int sound_volume;
  int music_volume;

  int max_fps;
  
  bool network_anticipation;

  U61_PlayerConfig player[U61_CONFIG_NB_PLAYERS];

 protected:
  void read_str(char *buf,char *name,char *def);
  int read_int(char *name,int def);
  bool read_bool(char *name,bool def);
  bool write_str(FILE *file,char *name, char *value); 
  bool write_int(FILE *file,char *name,int value);
  void read_player_str(char *buf,int pl,char *name,char *def);
  int read_player_int(int pl,char *name,int def);
  bool read_player_bool(int pl,char *name,bool def);
  bool write_player_str(int pl,FILE *file,char *name, char *value); 
  bool write_player_int(int pl,FILE *file,char *name,int value);
};

#endif
