/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   serverdispatcher.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the server dispatcher is the most complex of all dispatchers,
 *              it gets messages from all the clients, and sends them back
 *              to anyone who needs them
 */


#ifndef INC_U61_SERVERDISPATCHER
#define INC_U61_SERVERDISPATCHER

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "dispatcher.h"
#include "connection.h"
#include "history.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ServerDispatcher : public U61_Dispatcher
{
 public:
  U61_ServerDispatcher();
  virtual void reset();

  virtual bool send(U61_Event evt);
  virtual bool recv(U61_Event *evt);
  virtual bool peek();

  bool open(U61_Connection *c);
  void close(U61_Connection *c);
 protected:

  U61_History history[U61_DISPATCHER_MAX_PLAYER_ID];

  std::vector<U61_Connection *> connection;
};

#endif
