/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   script.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: wraps the LUA api to C++ and vice-versa
 *              all the interaction with lua is contained in this file
 *              it might be splited some day since it's getting *big*
 *              lua scripting is fundamental in u61. in fact all the
 *              rules of the game are coded in lua. this allows a 
 *              player/hacker  to write his own rules and test them
 *              right away without recompiling, and be quite
 *              "protection fault" safe
 */


#ifndef INC_U61_SCRIPT
#define INC_U61_SCRIPT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "block.h"
#include "map.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Script
{
public:
    static bool do_string(char *str);
    static bool do_file(char *file);
    static int get_global_int(char *name,int def=0);
    static char *get_global_str(char *name,char *def="");

    static bool init();
    static void collect_garbage();

    static int new_shape(U61_Map *m,U61_Block *b);
    static void do_shape(U61_Map *m,U61_Block *b,int type);
    static void rotate_left(U61_Map *m,U61_Block *b);
    static void rotate_right(U61_Map *m,U61_Block *b);
    static void move_left(U61_Map *m,U61_Block *b);
    static void move_right(U61_Map *m,U61_Block *b);
    static void move_down(U61_Map *m,U61_Block *b);
    static void land(U61_Map *m,U61_Block *b);
    static bool match_pattern(U61_Map *m);
    static void time_callback(U61_Map *m,U61_Block *b);
    static void square_blown_up(U61_Map *m,int x,int y);
    static int new_curse(U61_Map *m,U61_Block *b);
    static void do_curse(U61_Map *m,U61_Block *b,int id,bool sent);
    static void use_antidote(U61_Map *m,U61_Block *b);
    static char *get_curse_name(U61_Map *m,int id);

    static char *const LUA_NEW_SHAPE="user_new_shape";
    static char *const LUA_DO_SHAPE="user_do_shape";
    static char *const LUA_ROTATE_LEFT="user_rotate_left";
    static char *const LUA_ROTATE_RIGHT="user_rotate_right";
    static char *const LUA_MOVE_LEFT="user_move_left";
    static char *const LUA_MOVE_RIGHT="user_move_right";
    static char *const LUA_MOVE_DOWN="user_move_down";
    static char *const LUA_LAND="user_land";
    static char *const LUA_MATCH_PATTERN="user_match_pattern";
    static char *const LUA_TIME_CALLBACK="user_time_callback";
    static char *const LUA_SQUARE_BLOWN_UP="user_square_blown_up";
    static char *const LUA_NEW_CURSE="user_new_curse";
    static char *const LUA_DO_CURSE="user_do_curse";
    static char *const LUA_USE_ANTIDOTE="user_use_antidote";
    static char *const LUA_GET_CURSE_NAME="user_get_curse_name";

    static char *const C_RESET_BLOCK="u61_reset_block";
    static char *const C_CENTER_BLOCK="u61_center_block";
    static char *const C_GET_BLOCK_X="u61_get_block_x";
    static char *const C_GET_BLOCK_Y="u61_get_block_y";
    static char *const C_SET_BLOCK_X="u61_set_block_x";
    static char *const C_SET_BLOCK_Y="u61_set_block_y";
    static char *const C_ADD_ITEM="u61_add_item";
    static char *const C_GET_NB_ITEMS="u61_get_nb_items";
    static char *const C_GET_ITEM_X="u61_get_item_x";
    static char *const C_GET_ITEM_Y="u61_get_item_y";
    static char *const C_GET_ITEM_COLOR="u61_get_item_color";
    static char *const C_SET_ITEM_X="u61_set_item_x";
    static char *const C_SET_ITEM_Y="u61_set_item_y";
    static char *const C_SET_ITEM_COLOR="u61_set_item_color";
    static char *const C_GET_WIDTH="u61_get_width";
    static char *const C_GET_HEIGHT="u61_get_height";
    static char *const C_GET_SQUARE_COLOR="u61_get_square_color";
    static char *const C_SET_SQUARE_COLOR="u61_set_square_color";
    static char *const C_GET_TIME="u61_get_time";
    static char *const C_GET_SCORE="u61_get_score";
    static char *const C_SET_SCORE="u61_set_score";
    static char *const C_ADD_SCORE="u61_add_score";
    static char *const C_GET_GLOBAL="u61_get_global";
    static char *const C_SET_GLOBAL="u61_set_global";
    static char *const C_GET_ANTICIPATION_STATE="u61_get_anticipation_state";
    static char *const C_SET_ANTICIPATION_STATE="u61_set_anticipation_state";
    static char *const C_GET_PREVIEW_STATE="u61_get_preview_state";
    static char *const C_SET_PREVIEW_STATE="u61_set_preview_state";
    static char *const C_BLOW_UP_SQUARE="u61_blow_up_square";
    static char *const C_IS_SQUARE_EXPLODING="u61_is_square_exploding";
    static char *const C_GET_CURSE_X="u61_get_curse_x";
    static char *const C_GET_CURSE_Y="u61_get_curse_y";
    static char *const C_GET_CURSE_STATE="u61_get_curse_state";
    static char *const C_SET_CURSE_X="u61_set_curse_x";
    static char *const C_SET_CURSE_Y="u61_set_curse_y";
    static char *const C_SET_CURSE_STATE="u61_set_curse_state";
    static char *const C_IS_CURSE_AVAILABLE="u61_is_curse_available";
    static char *const C_SEND_CURSE="u61_send_curse";
    static char *const C_GET_CURSE_AGE="u61_get_curse_age";
    static char *const C_REGISTER_CURSE="u61_register_curse";
    static char *const C_CANCEL_CURSE="u61_cancel_curse";
    static char *const C_GET_OLDEST_CURSE="u61_get_oldest_curse";
    static char *const C_GET_NB_CURSES="u61_get_nb_curses";
    static char *const C_GET_NB_ANTIDOTES="u61_get_nb_antidotes";
    static char *const C_ADD_ANTIDOTE="u61_add_antidote";
    static char *const C_DELETE_ANTIDOTE="u61_delete_antidote";
    static char *const C_IS_BLOCK_OK="u61_is_block_ok";

protected:
    static void secure_pointers();
    static void record_all();
    static const int RANDOM_MAX=0x7FFFFFFF;
};

#endif
