/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   layout.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class contains layout items and is responsible for
 *              placing them on the screen, and then draw them when
 *              necessary. basically it decides to place local players
 *              in the middle of the screen and half/size network players
 *              and place them on the sides
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "layout.h"

#include "global.h"
#include "utils.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default layout
 */ 
U61_Layout::U61_Layout()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the layout
 */ 
U61_Layout::~U61_Layout()
{    
}

/*--------------------------------------------------------------------------*/
/*
 * resets the layout, ie resets all the layout items
 */
void U61_Layout::reset()
{
  int i;

  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      items[i].reset();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for single player mode
 */
void U61_Layout::init_alone(U61_Player *p)
{
  reset();

  items[0].init(p,
		U61_Global::data.screen_w/2,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for 1 local multiplayer player
 */
void U61_Layout::init_multiplayer_1(U61_Player *p1)
{
  init_alone(p1);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for 2 local multiplayer players
 */
void U61_Layout::init_multiplayer_2(U61_Player *p1,
                                    U61_Player *p2)
{
  reset();

  items[0].init(p1,
		(3*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[1].init(p2,
		(5*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for 3 local multiplayer players
 */
void U61_Layout::init_multiplayer_3(U61_Player *p1,
                                    U61_Player *p2,
                                    U61_Player *p3)
{
  reset();

  items[0].init(p1,
		U61_Global::data.screen_w/4,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[1].init(p2,
		U61_Global::data.screen_w/2,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[2].init(p3,
		(3*U61_Global::data.screen_w)/4,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for 4 local multiplayer players
 */
void U61_Layout::init_multiplayer_4(U61_Player *p1,
                                    U61_Player *p2,
                                    U61_Player *p3,
                                    U61_Player *p4)
{
  reset();

  items[0].init(p1,
		(1*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[1].init(p2,
		(3*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[2].init(p3,
		(5*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[3].init(p4,
		(7*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for a network game with 1 local player
 */
void U61_Layout::init_network_1(U61_Player *p1,
                                U61_Player *net)
{
  reset();

  items[4].init(p1,
		(4*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);

  init_network_common(net);
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for a network game with 2 local players
 */
void U61_Layout::init_network_2(U61_Player *p1,
				U61_Player *p2,
                                U61_Player *net)
{
  reset();

  items[4].init(p1,
		(3*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);
  items[5].init(p2,
		(5*U61_Global::data.screen_w)/8,
		U61_Global::data.screen_h/2,
		U61_Data::SIZE_BIG);

  init_network_common(net);
}

/*--------------------------------------------------------------------------*/
/*
 * Common initializations when running a network game
 */
void U61_Layout::init_network_common(U61_Player *net)
{
  int i,slot1,slot2,temp;
  int corres[]={0,1,2,3,4,5,6,7};

  /*
   * now we shuffle the network players so that they seem to appear
   * randomly on the screen
   */
  for (i=0;i<SHUFFLE_COUNT;++i)
    {
      slot1=U61_Utils::random(8);
      slot2=U61_Utils::random(8);
      temp=corres[slot1];
      corres[slot1]=corres[slot2];
      corres[slot2]=temp;     
    }

  items[0].init(net+corres[0],
		(1*U61_Global::data.screen_w)/16,
		(1*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[1].init(net+corres[1],
		(3*U61_Global::data.screen_w)/16,
		(1*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[2].init(net+corres[2],
		(1*U61_Global::data.screen_w)/16,
		(3*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[3].init(net+corres[3],
		(3*U61_Global::data.screen_w)/16,
		(3*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[6].init(net+corres[4],
		(13*U61_Global::data.screen_w)/16,
		(1*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[7].init(net+corres[5],
		(15*U61_Global::data.screen_w)/16,
		(1*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[8].init(net+corres[6],
		(13*U61_Global::data.screen_w)/16,
		(3*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
  items[9].init(net+corres[7],
		(15*U61_Global::data.screen_w)/16,
		(3*U61_Global::data.screen_h)/4,
		U61_Data::SIZE_SMALL);  
}

/*--------------------------------------------------------------------------*/
/*
 * draws the layout (draws all the layoutitems)
 */
void U61_Layout::draw()
{
  int i;

  if (exists_changed_background() || background==NULL)
    {
      prepare_background();
    }

  U61_Global::data.back->put_screen(0,0);
  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      items[i].draw();
    }    
}

/*--------------------------------------------------------------------------*/
/*
 * checks if the id of the player is correct and returns the next if not 
 */
int U61_Layout::check_player_id(int old_id,int own_id)
{
  int result=own_id;
  int i;
  int old=-1;

  /*
   * we try and find where's the player with the id given
   */
  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      if (items[i].get_player_id()==old_id)
	{
	  old=i;
	}
    }

  if (old<0 || old_id==own_id)
    {
      result=get_next_player_id(old_id,own_id);
    }
  else
    {
      result=old_id;
    }  

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the id of the previous player 
 */
int U61_Layout::get_prev_player_id(int old_id,int own_id)
{
  int result=own_id;
  int i,j;
  int old=-1;
  int new_id=-1;

  /*
   * we try and find where's the player with the id given
   */
  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      if (items[i].get_player_id()==old_id)
	{
	  old=i;
	}
    }

  if (old>=0)
    {
      /*
       * now we find the closest previous player that exists and get his id
       */
      j=old-1;
      for (i=0;i<NB_PLAYERS_TOTAL && result==own_id;++i)
        {
          if (j<0)
	    {
	      j+=NB_PLAYERS_TOTAL;
	    }
          if (items[j].is_player_available()
	      && (new_id=items[j].get_player_id())!=own_id)
	    {
	      result=new_id;
	    }
          j--;
        }
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the id of the next player 
 */
int U61_Layout::get_next_player_id(int old_id,int own_id)
{
  int result=own_id;
  int i,j;
  int old=-1;
  int new_id=-1;

  /*
   * we try and find where's the player with the id given
   */
  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      if (items[i].get_player_id()==old_id)
	{
	  old=i;
	}
    }

  if (old>=0)
    {
      /*
       * now we find the closest next player that exists and get his id
       */
      j=old+1;
      for (i=0;i<NB_PLAYERS_TOTAL && result==own_id;++i)
        {
          if (j>=NB_PLAYERS_TOTAL)
	    {
	      j-=NB_PLAYERS_TOTAL;
	    }
          if (items[j].is_player_available()
	      && (new_id=items[j].get_player_id())!=own_id)
	    {
	      result=new_id;
	    }
          j++;
        }
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if one of the backgrounds has changed
 */
bool U61_Layout::exists_changed_background()
{
  bool found;
  int i;
 
  found=false;
  for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
      found=found || items[i].has_background_changed();
    }

  return found;
}

/*--------------------------------------------------------------------------*/
/*
 * prepares the background
 * we use a bitmap to hold the background of the game, ie the global bg tile
 * plus the backgrounds of each bitmap to avoid redrawing the map
 * backgrounds all the time, since they don't change very often
 */
void U61_Layout::prepare_background()
{

}
