/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   protocol.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains the network code which is needed to initialize the
 *              maps on the client. this can be quite a complex process
 *              since we can not interrupt the game when someone logs in.
 *              and the amount of data to transmit might be high 
 *              (especially if the lua scripts are big)
 *              So we use lots of small messages and this forms what
 *              I call the "login protocol" and is maybe the most complex
 *              thing in U61...
 */


#ifndef INC_U61_PROTOCOL
#define INC_U61_PROTOCOL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "connection.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Protocol
{
 public:
  U61_Protocol(int p,int c);
  virtual ~U61_Protocol();

  virtual void check_connection();
  virtual int send_next_packet();
  virtual int recv_next_packet();
  void reset();
  int get_stage();
  bool done();
  int send_all();
  int recv_all();
  void print_diagnostic();

  const static int DONE=0;
  const static int LATER=1;
  const static int FAILED=2;

  const static int BEGIN=0;
  const static int END=-1;

  const static int ID_SENT=20;
  const static int ID_RECEIVED=21;
  const static int VERSION_SENT=22;
  const static int VERSION_RECEIVED=23;
  const static int READY_SENT=50;
  const static int READY_RECEIVED=51;
  const static int TIMEOUT=10;

 protected:
  int stage;
  int step;
  int port;
  int channel;
  string diagnostic;

  CL_NetGame *game;

  static char *const GAME_ID="U61 by U-Foot";
  static char *const READY_MESSAGE="Ready";

  int send_id(U61_Connection *conn);
  int recv_id(U61_Connection *conn);
  int send_version(U61_Connection *conn);
  int recv_version(U61_Connection *conn);
  int send_ready(U61_Connection *conn);
  int recv_ready(U61_Connection *conn);
};

#endif


