/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        menuinput.h
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: February 2000
 * description: input class which handles menu events
 */

#ifndef INC_U61_MENUINPUT
#define INC_U61_MENUINPUT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "input.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_MenuInput : public U61_Input
{ 
public:
    U61_MenuInput();
    ~U61_MenuInput();
 
    void init();

    void poll_mouse();
    int get_mouse_y();

protected:
    const static int MOUSE_DELAY=50;
    const static int REPEAT_FIRST=50;
    const static int REPEAT_STANDARD=15;

    int mouse_last_fired;
    int mouse_y;
};

#endif

