------------------------------------------------------------------------------
-- This is a script file for U61 by U-Foot (www.ufoot.org ufoot@ufoot.org)  --
-- It is free software, protected by the GPL (www.fsf.org)                  --
--                                                                          --
-- Do not hesitate to modify this file to change the behavior of U61,       --
-- that's exactly what it's done for!                                       --
------------------------------------------------------------------------------


------------------------------------------------------------------------------
--                                                                          --
-- U U    6   1            U U   FFF  O   O  TTT                            --
-- U U   6   11   b        U U   F   O O O O  T                             --
-- U U - 66   1   bb  y y  U U - FF  O O O O  T                             --
-- U U   6 6  1   b b  y   U U   F   O O O O  T                             --
--  U     6   1   bb   y    U    F    O   O   T                             --
--                                                                          --
-- U61 is another block based game                                          --
-- Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   --
--                                                                          --
-- This program is free software; you can redistribute it and/or            --
-- modify it under the terms of the GNU General Public License              --
-- as published by the Free Software Foundation; either version 2           --
-- of the License, or (at your option) any later version.                   --
--                                                                          --
-- This program is distributed in the hope that it will be useful,          --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of           --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            --
-- GNU General Public License for more details.                             --
--                                                                          --
-- You should have received a copy of the GNU General Public License        --
-- along with this program; if not, write to the Free Software              --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA--
--                                                                          --
-- This project is also available on SourceForge  (http://sourceforge.net)  --
------------------------------------------------------------------------------

-- vertical blocks with 3 squares fall. one can translate them and change
-- the colors, but not rotate them. the goal is to have lines or diags
-- of 3 squares of the same color


-- shape definition ----------------------------------------------------------

function user_new_shape(num)
    return num
end 

function user_do_shape(num)
    vertical_colored_bar(3,num)
end


-- actions -------------------------------------------------------------------

function user_rotate_left()
    cycle_forward()    
end

function user_rotate_right()
    cycle_backward()    
end

function user_move_left()
    translate_block_x(-1)
end

function user_move_right()
    translate_block_x(1)
end

function user_move_down()
    translate_block_y(1)
end

function user_use_antedote()
    u61_cancel_curse(u61_get_oldest_curse())
end

-- pattern match -------------------------------------------------------------

function user_match_pattern(match_count)
    return match_color(match_count,3)
end

function user_land()

end

function user_square_blown_up(x,y)
    shift_column_down(x,y)
end

-- curse functions  ----------------------------------------------------------

function user_new_curse(num)
    num=mod(num,4)

    return num
end

function user_do_curse(num,sent)

end

function user_get_curse_name(num)
    name="..."

    return name
end

-- other functions -----------------------------------------------------------

function user_time_callback()
    u61_add_score(1)
end


-- various functions used for pattern matching -------------------------------

function shift_column_down(x_col,y_bottom)
    local y
    local color

    y=y_bottom
    while y>1 do
        color=u61_get_square_color(x_col,y-1)
        u61_set_square_color(x_col,y,color)
        y=y-1
    end
    u61_set_square_color(x_col,0,-1)

    if u61_get_curse_x()==x_col and u61_get_curse_y()<y_bottom then
        u61_set_curse_y(u61_get_curse_y()+1)
    end
end









-- Functions used in many curse scripts --------------------------------------

function shift_map_up()
    local x
    local y
    local width
    local height
    local color

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height-1 do
        x=0
        while x<width do
            color=u61_get_square_color(x,y+1)
            u61_set_square_color(x,y,color)
            x=x+1
        end
        y=y+1
    end

    u61_set_curse_y(u61_get_curse_y()-1)
end

function clear_map()
    local x
    local y
    local width
    local height

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height do
        x=0
        while x<width do
            u61_set_square_color(x,y,-1)
            x=x+1
        end
        y=y+1
    end
end
-- vertical colored bar of any size ------------------------------------------

function vertical_colored_bar(y_size,num)
    local y

    y=0
    while y<y_size do
        u61_add_item(0,y,mod(num,7))
        num=floor(num/7)
        y=y+1
    end
end



-- defines translations ------------------------------------------------------

function translate_block_x(x)
    u61_set_block_x(u61_get_block_x()+x)
end

function translate_block_y(y)
    u61_set_block_y(u61_get_block_y()+y)
end


-- defines color cycling -----------------------------------------------------

function cycle_forward()
    local size
    local i
    local temp_color
 
    size=u61_get_nb_items()

    temp_color=u61_get_item_color(size-1)

    i=size-1
    while i>0 do
        u61_set_item_color(i,u61_get_item_color(i-1))
        i=i-1
    end
        
    u61_set_item_color(0,temp_color)
end

function cycle_backward()
    local size
    local i
    local temp_color
 
    size=u61_get_nb_items()

    temp_color=u61_get_item_color(0)

    i=0
    while i<size-1 do
        u61_set_item_color(i,u61_get_item_color(i+1))
        i=i+1
    end
        
    u61_set_item_color(size-1,temp_color)
end




-- color pattern: columns, lines diags of n squares with same colors ---------


function match_color_vertical(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_get_square_color(x+i,y)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_blow_up_square(x+i,y)
        i=i+1
    end 
    
    return found_size 
end

function match_color_horizontal(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_get_square_color(x,y+i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_blow_up_square(x,y+i)
        i=i+1
    end 
    
    return found_size 
end

function match_color_diagonal1(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_get_square_color(x+i,y+i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_blow_up_square(x+i,y+i)
        i=i+1
    end 
    
    return found_size 
end

function match_color_diagonal2(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_get_square_color(x+i,y-i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_blow_up_square(x+i,y-i)
        i=i+1
    end 
    
    return found_size 
end

function match_color(match_count,min_size)
    local x
    local y
    local width
    local height
    local found
    local nb_found
    
    width=u61_get_width()
    height=u61_get_height()

    found=0
    nb_found=0
    y=height-1
    while y>=0 do
        x=0
        while x<width do
            nb_found=match_color_vertical(x,y,min_size)
            if nb_found>0 then
                found=1
            else 
                nb_found=match_color_horizontal(x,y,min_size)
                if nb_found>0 then
                    found=1
                else
                    nb_found=match_color_diagonal1(x,y,min_size)
                    if nb_found>0 then
                        found=1
                    else
                        nb_found=match_color_diagonal2(x,y,min_size)
                        if nb_found>0 then
                            found=1
                        end
                    end
                end
            end
            x=x+1
        end
        y=y-1
    end

    if found~=0 then
        u61_add_score((match_count+1)*1000)
    end

    return found
end

