/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   square.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a square is the basic atomic object in u61. it's about
 *              the very squares you see on the screen. a square can be
 *              contained in a block (when falling) or in a map (when stable)
 *              it provides an API to be drawn and is automatically 
 *              animated.
 *              the main attribute of a square is its color
 */


#ifndef INC_U61_SQUARE
#define INC_U61_SQUARE

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "data.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Square
{
 public:
  U61_Square();
  ~U61_Square();
    
  void reset();
    
  void enable();
  void disable();
  bool is_enabled();
  bool is_disabled();

  void set_color(int c);
  int get_color();

  static void update_cycle();
  void draw(int x,int y, int size=U61_Data::SIZE_BIG);
  void draw_prevision(int x,int y, int size=U61_Data::SIZE_BIG);
  void draw_curse_fg(int x,int y, int size=U61_Data::SIZE_BIG);
  void draw_curse_bg(int x,int y, int size=U61_Data::SIZE_BIG);

  void begin_explosion();
  void end_explosion();
  void update_explosion();
  bool is_explosion_ended();
  bool is_exploding();
    

  const static int NB_COLORS=8;
    
 protected:
  int cycle_offset;
  int explosion_counter;
  int color;
  bool state;
  bool exploding;

  static int cycle;
    
  const static int EXPLOSION_LENGTH=50;
  const static int NB_BITMAP=16;
  const static int TIME_FACTOR=3;
};

#endif
