/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   config.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the config object holds all the values which are stored
 *              on the HD between two game sessions. it would for instance
 *              store the player names and key settings
 *              it basically provides functions to load and save all the
 *              game parameters, and makes these parameters usable by any
 *              other class.
 *              it also provides some function which help handling game
 *              settings in general
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "config.h"
#include "platform.h"
#include "script.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation with default values
 */ 
U61_Config::U61_Config()
{

}

/*--------------------------------------------------------------------------*/
/*
 * destruction
 */
U61_Config::~U61_Config()
{

}

/*--------------------------------------------------------------------------*/
/* 
 * initialization with values from the config file
 */ 
bool U61_Config::read()
{
  bool ok=false;
  char *filename;

  //cout<<"read config\n";
  filename=U61_Platform::get_config_file();
  //cout<<"Loading config from \""<<filename<<"\".\n";

  U61_Script::do_file(filename);

  //cout<<"coucou conf\n";
  if (read_int(ID_DUMMY,0)==DUMMY_VALUE)
    {
      ok=true;
    }

  reset();
 
  return ok;
}
   
/*--------------------------------------------------------------------------*/
/* 
 * initialization with lua config file values
 */ 
void U61_Config::reset()
{
  int pl;
  char default_data_file[U61_STRING_SIZE];
  char default_script_file[U61_STRING_SIZE];

  strcpy(default_data_file,U61_Platform::get_data_path());
  strcat(default_data_file,"classic.dat");
  strcpy(default_script_file,U61_Platform::get_data_path());
  strcat(default_script_file,"classic.lua");

  launch_count=read_int(ID_LAUNCH_COUNT,0);
  read_str(data_file,ID_DATA_FILE,default_data_file);
  read_str(script_file,ID_SCRIPT_FILE,default_script_file);

  read_str(server_id,ID_SERVER_ID,"127.0.0.1");
  network_port=read_int(ID_NETWORK_PORT,8061);
  network_channel=read_int(ID_NETWORK_CHANNEL,1);
        
  initial_speed=read_int(ID_INITIAL_SPEED,5);
  acceleration=read_int(ID_ACCELERATION,5);

  sound_volume=read_int(ID_SOUND_VOLUME,10);
  music_volume=read_int(ID_MUSIC_VOLUME,10);

  max_fps=read_int(ID_MAX_FPS,18);

  network_prevision=read_int(ID_NETWORK_PREVISION,false);

  for (pl=0;pl<NB_PLAYERS;++pl)
    {
      player[pl].first_repeat_move=
	read_player_int(pl,ID_FIRST_REPEAT_MOVE,10);
      player[pl].standard_repeat_move=
	read_player_int(pl,ID_STANDARD_REPEAT_MOVE,5);
      player[pl].first_repeat_rotate=
	read_player_int(pl,ID_FIRST_REPEAT_ROTATE,20);
      player[pl].standard_repeat_rotate=
	read_player_int(pl,ID_STANDARD_REPEAT_ROTATE,10);
      player[pl].first_repeat_other=
	read_player_int(pl,ID_FIRST_REPEAT_OTHER,40);
      player[pl].standard_repeat_other=
	read_player_int(pl,ID_STANDARD_REPEAT_OTHER,20);
      player[pl].prevision=
	read_player_int(pl,ID_PREVISION,false);
    }

  player[0].activable=read_player_int(0,ID_ACTIVABLE,true);
  read_player_str(player[0].name,0,ID_NAME,"ufoot");
  player[0].key_start_stop=read_player_int(0,ID_KEY_START_STOP, CL_KEY_1);
  player[0].key_move_left=read_player_int(0,ID_KEY_MOVE_LEFT, CL_KEY_LEFT);
  player[0].key_move_right=read_player_int(0,ID_KEY_MOVE_RIGHT, CL_KEY_RIGHT);
  player[0].key_rotate_left=read_player_int(0,ID_KEY_ROTATE_LEFT, CL_KEY_Q);
  player[0].key_rotate_right=read_player_int(0,ID_KEY_ROTATE_RIGHT, CL_KEY_UP);
  player[0].key_move_down=read_player_int(0,ID_KEY_MOVE_DOWN, CL_KEY_DOWN);
  player[0].key_drop=read_player_int(0,ID_KEY_DROP, CL_KEY_SPACE);
  player[0].key_next_victim=read_player_int(0,ID_KEY_NEXT_VICTIM, CL_KEY_W);
  player[0].key_prev_victim=read_player_int(0,ID_KEY_PREV_VICTIM, CL_KEY_E);
  player[0].key_use_antedote=read_player_int(0, ID_KEY_USE_ANTEDOTE, CL_KEY_R);

  player[1].activable=read_player_int(1,ID_ACTIVABLE,true);
  read_player_str(player[1].name,1,ID_NAME,"etoile");
  player[1].key_start_stop=read_player_int(1,ID_KEY_START_STOP, CL_KEY_1);
  player[1].key_move_left=read_player_int(1,ID_KEY_MOVE_LEFT, CL_KEY_LEFT);
  player[1].key_move_right=read_player_int(1,ID_KEY_MOVE_RIGHT, CL_KEY_RIGHT);
  player[1].key_rotate_left=read_player_int(1,ID_KEY_ROTATE_LEFT, CL_KEY_Q);
  player[1].key_rotate_right=read_player_int(1,ID_KEY_ROTATE_RIGHT, CL_KEY_UP);
  player[1].key_move_down=read_player_int(1,ID_KEY_MOVE_DOWN, CL_KEY_DOWN);
  player[1].key_drop=read_player_int(1,ID_KEY_DROP, CL_KEY_SPACE);
  player[1].key_next_victim=read_player_int(1,ID_KEY_NEXT_VICTIM, CL_KEY_W);
  player[1].key_prev_victim=read_player_int(1,ID_KEY_PREV_VICTIM, CL_KEY_E);
  player[1].key_use_antedote=read_player_int(1, ID_KEY_USE_ANTEDOTE, CL_KEY_R);

  player[2].activable=read_player_int(2,ID_ACTIVABLE,true);
  read_player_str(player[2].name,2,ID_NAME,"toto");
  player[2].key_start_stop=read_player_int(2,ID_KEY_START_STOP, CL_KEY_1);
  player[2].key_move_left=read_player_int(2,ID_KEY_MOVE_LEFT, CL_KEY_LEFT);
  player[2].key_move_right=read_player_int(2,ID_KEY_MOVE_RIGHT, CL_KEY_RIGHT);
  player[2].key_rotate_left=read_player_int(2,ID_KEY_ROTATE_LEFT, CL_KEY_Q);
  player[2].key_rotate_right=read_player_int(2,ID_KEY_ROTATE_RIGHT, CL_KEY_UP);
  player[2].key_move_down=read_player_int(2,ID_KEY_MOVE_DOWN, CL_KEY_DOWN);
  player[2].key_drop=read_player_int(2,ID_KEY_DROP, CL_KEY_SPACE);
  player[2].key_next_victim=read_player_int(2,ID_KEY_NEXT_VICTIM, CL_KEY_W);
  player[2].key_prev_victim=read_player_int(2,ID_KEY_PREV_VICTIM, CL_KEY_E);
  player[2].key_use_antedote=read_player_int(2, ID_KEY_USE_ANTEDOTE, CL_KEY_R);

  player[3].activable=read_player_int(3,ID_ACTIVABLE,true);
  read_player_str(player[3].name,3,ID_NAME,"zorro");
  player[3].key_start_stop=read_player_int(3,ID_KEY_START_STOP, CL_KEY_1);
  player[3].key_move_left=read_player_int(3,ID_KEY_MOVE_LEFT, CL_KEY_LEFT);
  player[3].key_move_right=read_player_int(3,ID_KEY_MOVE_RIGHT, CL_KEY_RIGHT);
  player[3].key_rotate_left=read_player_int(3,ID_KEY_ROTATE_LEFT, CL_KEY_Q);
  player[3].key_rotate_right=read_player_int(3,ID_KEY_ROTATE_RIGHT, CL_KEY_UP);
  player[3].key_move_down=read_player_int(3,ID_KEY_MOVE_DOWN, CL_KEY_DOWN);
  player[3].key_drop=read_player_int(3,ID_KEY_DROP, CL_KEY_SPACE);
  player[3].key_next_victim=read_player_int(3,ID_KEY_NEXT_VICTIM, CL_KEY_W);
  player[3].key_prev_victim=read_player_int(3,ID_KEY_PREV_VICTIM, CL_KEY_E);
  player[3].key_use_antedote=read_player_int(3, ID_KEY_USE_ANTEDOTE, CL_KEY_R);
}

/*--------------------------------------------------------------------------*/
/* 
 * saves the values to the config file
 */ 
bool U61_Config::write()
{
  bool ok=false;
  char *filename;
  FILE *file;
  int pl;

  //cout<<"write config\n";
  if (U61_Platform::create_user_dir())
    {
      filename=U61_Platform::get_config_file();
      //cout<<"Writing config to \""<<filename<<"\".\n";
      file=fopen(filename,"w");

      if (file!=NULL)
	{
	  ok=true;

	  ok=ok && write_int(file,ID_DUMMY, DUMMY_VALUE);
	  ok=ok && write_int(file,ID_LAUNCH_COUNT, launch_count+1);

	  ok=ok && write_str(file,ID_DATA_FILE, data_file);
	  ok=ok && write_str(file,ID_SCRIPT_FILE, script_file);

	  ok=ok && write_str(file,ID_SERVER_ID, server_id);
	  ok=ok && write_int(file,ID_NETWORK_PORT, network_port);
	  ok=ok && write_int(file,ID_NETWORK_CHANNEL, network_channel);

	  ok=ok && write_int(file,ID_INITIAL_SPEED, initial_speed);
	  ok=ok && write_int(file,ID_ACCELERATION, acceleration);

	  ok=ok && write_int(file,ID_SOUND_VOLUME, sound_volume);
	  ok=ok && write_int(file,ID_MUSIC_VOLUME, music_volume);

	  ok=ok && write_int(file,ID_MAX_FPS, max_fps);

	  ok=ok && write_int(file,ID_NETWORK_PREVISION, network_prevision);

	  for (pl=0;pl<NB_PLAYERS;++pl)
	    {
	      ok=ok && write_player_int(pl,file,ID_FIRST_REPEAT_MOVE,
					player[pl].first_repeat_move);
	      ok=ok && write_player_int(pl,file,ID_STANDARD_REPEAT_MOVE,
					player[pl].standard_repeat_move);
	      ok=ok && write_player_int(pl,file,ID_FIRST_REPEAT_ROTATE,
					player[pl].first_repeat_rotate);
	      ok=ok && write_player_int(pl,file,ID_STANDARD_REPEAT_ROTATE,
					player[pl].standard_repeat_rotate);
	      ok=ok && write_player_int(pl,file,ID_FIRST_REPEAT_OTHER,
					player[pl].first_repeat_other);
	      ok=ok && write_player_int(pl,file,ID_STANDARD_REPEAT_OTHER,
					player[pl].standard_repeat_other);
 
	      ok=ok && write_player_int(pl,file,ID_PREVISION,
					player[pl].prevision);

	      ok=ok && write_player_int(pl,file,ID_ACTIVABLE,
					player[pl].activable);
	      ok=ok && write_player_str(pl,file,ID_NAME,
					player[pl].name);

	      ok=ok && write_player_int(pl,file,ID_KEY_START_STOP,
					player[pl].key_start_stop);
	      ok=ok && write_player_int(pl,file,ID_KEY_MOVE_LEFT,
					player[pl].key_move_left);
	      ok=ok && write_player_int(pl,file,ID_KEY_MOVE_RIGHT,
					player[pl].key_move_right);
	      ok=ok && write_player_int(pl,file,ID_KEY_ROTATE_LEFT,
					player[pl].key_rotate_left);
	      ok=ok && write_player_int(pl,file,ID_KEY_ROTATE_RIGHT,
					player[pl].key_rotate_right);
	      ok=ok && write_player_int(pl,file,ID_KEY_MOVE_DOWN,
					player[pl].key_move_down);
	      ok=ok && write_player_int(pl,file,ID_KEY_DROP,
					player[pl].key_drop);
	      ok=ok && write_player_int(pl,file,ID_KEY_NEXT_VICTIM,
					player[pl].key_next_victim);
	      ok=ok && write_player_int(pl,file,ID_KEY_PREV_VICTIM,
					player[pl].key_prev_victim);
	      ok=ok && write_player_int(pl,file,ID_KEY_USE_ANTEDOTE,
					player[pl].key_use_antedote);
	    } 

	  fclose(file);
	}
    }
  return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * loads the user scripts that will be used by the script module
 */
bool U61_Config::load_script()
{
  bool ok=false;

  //cout<<"Loading scripts from \""<<script_file<<"\".\n";

  ok=U61_Script::do_file(script_file);
    
  return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * loads a string entry from the config file
 */
void U61_Config::read_str(char *buf, char *name,char *def)
{
  strcpy(buf,U61_Script::get_global_str(name,def));
}

/*--------------------------------------------------------------------------*/
/*
 * loads a number entry from the config file
 */
int U61_Config::read_int(char *name,int def)
{
  return U61_Script::get_global_int(name,def);
}

/*--------------------------------------------------------------------------*/
/*
 * saves a string entry into the config file
 */
bool U61_Config::write_str(FILE *file,char *name,char *value)
{
  char buffer[U61_STRING_SIZE];
  bool ok;

  strcpy(buffer,name);
  strcat(buffer," = \"");
  strcat(buffer,value);
  strcat(buffer,"\"\n");

  ok=(fwrite(buffer,strlen(buffer),1,file)>0);

  return ok;
} 

/*--------------------------------------------------------------------------*/
/*
 * saves a numeric entry into the config file
 */
bool U61_Config::write_int(FILE *file,char *name,int value)
{
  char buffer[U61_STRING_SIZE];
  char buffer2[20];
  bool ok;

  sprintf(buffer2,"%d",value);

  strcpy(buffer,name);
  strcat(buffer," = ");
  strcat(buffer,buffer2);
  strcat(buffer,"\n");

  ok=(fwrite(buffer,strlen(buffer),1,file)>0);

  return ok;
} 

/*--------------------------------------------------------------------------*/
/*
 * loads a string entry from the config file, for a specific player
 */
void U61_Config::read_player_str(char *buf,int pl,char *name,char *def)
{
  char buffer[U61_STRING_SIZE];

  sprintf(buffer,ID_PLAYER,pl);
  strcat(buffer,name);

  read_str(buf,buffer,def);
}

/*--------------------------------------------------------------------------*/
/*
 * loads a number entry from the config file, for a specific player
 */
int U61_Config::read_player_int(int pl,char *name,int def)
{
  char buffer[U61_STRING_SIZE];

  sprintf(buffer,ID_PLAYER,pl);
  strcat(buffer,name);

  return read_int(buffer,def);
}

/*--------------------------------------------------------------------------*/
/*
 * saves a string entry into the config file, for a specific player
 */
bool U61_Config::write_player_str(int pl,FILE *file,char *name,char *value)
{
  char buffer[U61_STRING_SIZE];

  sprintf(buffer,ID_PLAYER,pl);
  strcat(buffer,name);

  return write_str(file,buffer,value);
} 

/*--------------------------------------------------------------------------*/
/*
 * saves a numeric entry into the config file, for a specific player
 */
bool U61_Config::write_player_int(int pl,FILE *file,char *name,int value)
{
  char buffer[U61_STRING_SIZE];

  sprintf(buffer,ID_PLAYER,pl);
  strcat(buffer,name);

  return write_int(file,buffer,value);
} 



