/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   alonemenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is launched "in game" when escape is pressed to
 *              - allow some options to be changed without stopping the game.
 *              - stop the game if wanted 
 *              it is used for local games with one single player
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "alonemenu.h"
#include "pausingmenu.h"
#include "playermenu.h"
#include "soundmenu.h"
#include "button.h"
#include "time.h"
#include "global.h"
#include "game.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_AloneMenu::U61_AloneMenu(U61_Menu *parent)
  : U61_Menu(parent,"Local game running")
{
  add_item(new U61_Button("Stop this game"));
  add_item(new U61_Button("Resume"));
  add_item(new U61_Button("Options"));
  add_item(new U61_Button("Sound"));
  select(0);
  shade();
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_AloneMenu::validate()
{
  U61_Menu *next_menu;

  next_menu=this;
  switch (selection)
    {
    case 0:
      next_menu=parent_menu;
      U61_Global::game.stop();
      break;
    case 1:
      next_menu=back();
      break;
    case 2:
      next_menu=new U61_PlayerMenu(this, 
				   &(U61_Global::config.player
				     [U61_Global::game.get_local_player(0)]));
      break;
    case 3:
      next_menu=new U61_SoundMenu(this, &(U61_Global::config));
      break;
    }

  return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * back to the game
 */
U61_Menu *U61_AloneMenu::back()
{
  U61_Menu *next_menu;

  next_menu=new U61_PausingMenu(this);
  U61_Time::resume();
  U61_Global::game.configure_hot();

  return next_menu;
}

