/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   localsource.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a local source is the event source used for local players
 *              it polls informations
 *              - from the keyboard
 *              - from the map (for new block management for instance)
 *              it also generates dummy events regularly so that there's
 *              not too wide a gap between the "last" and "sure" members
 *              of the map class
 */

#ifndef INC_U61_LOCALSOURCE
#define INC_U61_LOCALSOURCE

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "eventsource.h"
#include "map.h"
#include "input.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_LocalSource : public U61_EventSource
{ 
public:
    U61_LocalSource(U61_Input *i,U61_Map *m);
    ~U61_LocalSource();

    void poll();
    void send_start_stop(int time);
    
protected:
    static const int DUMMY_DELAY=10;
    void poll_input();
    void poll_map();
    void poll_dummy();

    int dummy_counter;

    U61_Input *input;
    U61_Map *map;
};

#endif
