/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   clientprotocol.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the client sends informations about him and retrieves
 *              information from the server, including the rules and
 *              the state of all the other players
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "clientprotocol.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * creates a client protocol
 */
U61_ClientProtocol::U61_ClientProtocol(U61_ClientDispatcher *d, 
				       int p,int ch,
                                       char *id) : U61_Protocol(p,ch)
{
  server_id=id;
  connection=NULL;
}

/*--------------------------------------------------------------------------*/
/*
 * deletes the protocol object
 */
U61_ClientProtocol::~U61_ClientProtocol()
{
  if (connection!=NULL)
    {
      delete connection;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * sends the next packet. sometimes there's not really a packet send but
 * the point is to identify the sequence of messages to send to the server
 */
int U61_ClientProtocol::send_next_packet()
{
  int result=LATER;

  switch(stage)
    {
    case BEGIN:
      if ((result=start_searching())==DONE)
	{
	  stage=SEARCHING;
          cout<<"stage=SEARCHING\n";
	}
      break;
    case CONNECTED_TO_SERVER:
      if ((result=send_id(connection))==DONE)
	{
	  stage=ID_SENT;
          cout<<"stage=ID_SENT\n";
	}
      break;
    case ID_RECEIVED:
      if ((result=send_version(connection))==DONE)
	{
	  stage=VERSION_SENT;
          cout<<"stage=VERSION_SENT\n";
	}
      break;
    case VERSION_RECEIVED:
      // cout<<"ok\n";
      break;
    }
  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * receives the next packet. sometimes there's not really a packet send but
 * the point is to identify the sequence of messages to receive from the
 * server
 */
int U61_ClientProtocol::recv_next_packet()
{
  int result=LATER;

  switch(stage)
    {
    case SEARCHING:
      if ((result=connect_to_server())==DONE)
	{
	  stage=CONNECTED_TO_SERVER;
          cout<<"stage=CONNECTED_TO_SERVER\n";
	}
      break;
    case ID_SENT:
      if ((result=recv_id(connection))==DONE)
	{  
          stage=ID_RECEIVED;
          cout<<"stage=ID_RECEIVED\n";
	}
      break;
    case VERSION_SENT:
      if ((result=recv_version(connection))==DONE)
	{
	  stage=VERSION_RECEIVED;
          cout<<"stage=VERSION_RECEIVED\n";
	}
      break;
    }
  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * enter the server search state
 */
int U61_ClientProtocol::start_searching()
{
  int result=LATER;

  try 
    {
      CL_Network::find_game_at(GAME_ID,server_id,port);
      result=DONE;
    }
  catch (CL_Error e)
    {
      cout<<"Find error : "<<e.message<<"\n";
    }

  //  cout<<"start searching\n";

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * tries to find out if a game has been found on the server
 * and obtain a connection from this server
 */
int U61_ClientProtocol::connect_to_server()
{
  int result=LATER;
  CL_NetComputer *server;

  try 
    {
      if (CL_Network::peek_game_found())
	{
	  game=CL_Network::receive_game_found(TIMEOUT);
	  if (game!=NULL)
	    {
              /*
               * OK, a game has been found, so now we really open
               * a connection with the server. The server is the only
               * computer we'll talk to
               */
              server=(CL_NetComputer *) game->get_server();
              connection=new U61_Connection(game,server,channel);
	      result=DONE;
	    }
          else
            {
              cout<<"...\n";
	    }
	}
    }
  catch (CL_Error e)
    {
      cout<<"Connect error : "<<e.message<<"\n";
    }
  //cout<<"find server\n";

  return result;
}











