
-- color pattern: columns, lines diags of n squares with same colors ---------


function match_color_vertical(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_map_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_map_get_square_color(x+i,y)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_map_blow_up_square(x+i,y)
        i=i+1
    end 
    
    return found_size 
end

function match_color_horizontal(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_map_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_map_get_square_color(x,y+i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_map_blow_up_square(x,y+i)
        i=i+1
    end 
    
    return found_size 
end

function match_color_diagonal1(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_map_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_map_get_square_color(x+i,y+i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_map_blow_up_square(x+i,y+i)
        i=i+1
    end 
    
    return found_size 
end

function match_color_diagonal2(x,y,min_size)
    local i
    local found_size
    local color
    local found_color

    found_size=0
    color=u61_map_get_square_color(x,y)
    if color>=0 then
        i=0
        repeat 
            found_color=u61_map_get_square_color(x+i,y-i)
            i=i+1 
        until found_color~=color or found_color<0
        found_size=i-1
    end
    if found_size<min_size then
        found_size=0
    end 
    i=0
    while i<found_size do
        u61_map_blow_up_square(x+i,y-i)
        i=i+1
    end 
    
    return found_size 
end

function match_color(match_count,min_size)
    local x
    local y
    local width
    local height
    local found
    
    width=u61_map_get_width()
    height=u61_map_get_height()

    found=0
    y=height-1
    while y>=0 do
        x=0
        while x<width do
            nb_found=match_color_vertical(x,y,min_size)
            if nb_found>0 then
                found=1
            else 
                nb_found=match_color_horizontal(x,y,min_size)
                if nb_found>0 then
                    found=1
                else
                    nb_found=match_color_diagonal1(x,y,min_size)
                    if nb_found>0 then
                        found=1
                    else
                        nb_found=match_color_diagonal2(x,y,min_size)
                        if nb_found>0 then
                            found=1
                        end
                    end
                end
            end
            x=x+1
        end
        y=y-1
    end

    if found~=0 then
        u61_map_add_score((match_count+1)*1000)
    end

    return found
end

