/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   square.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a square is the basic atomic object in u61. it's about
 *              the very squares you see on the screen. a square can be
 *              contained in a block (when falling) or in a map (when stable)
 *              it provides an API to be drawn and is automatically 
 *              animated.
 *              the main attribute of a square is its color
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "square.h"
#include "global.h"
#include "time.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * this integer is used to animate the squares
 */
int U61_Square::cycle=0;
 

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default square
 */ 
U61_Square::U61_Square()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the square
 */ 
U61_Square::~U61_Square()
{
    
}

/*--------------------------------------------------------------------------*/
/* 
 * sets square values to default
 */ 
void U61_Square::reset()
{
    color=0;
    state=false;
    cycle_offset=0;
}

/*--------------------------------------------------------------------------*/
/* 
 * set the square as active
 */ 
void U61_Square::enable()
{
    state=true;
}

/*--------------------------------------------------------------------------*/
/* 
 * set the square as inactive
 */ 
void U61_Square::disable()
{
    state=false;
}

/*--------------------------------------------------------------------------*/
/* 
 * returns true if the square is active
 */ 
bool U61_Square::is_enabled()
{
    return state;
}

/*--------------------------------------------------------------------------*/
/* 
 * returns true if the square is inactive
 */ 
bool U61_Square::is_disabled()
{
    return !state;
}

/*--------------------------------------------------------------------------*/
/*
 * sets the type of the square
 */
void U61_Square::set_color(int c)
{
    if (c>=0 && c<NB_COLORS)
    {
        color=c;
    }
    else
    {
        color=0;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * returns the type of the square
 */
int U61_Square::get_color()
{
    return color;
}

/*--------------------------------------------------------------------------*/
/*
 * updates the cycle integer, which depends on current time 
 */
void U61_Square::update_cycle()
{
    cycle=(U61_Time::for_effect()/TIME_FACTOR)%NB_BITMAP;
}

/*--------------------------------------------------------------------------*/
/*
 * draws the square
 */
void U61_Square::draw(int x, int y,int size)
{
    if (state)
    {
        U61_Global::data.square[color][size]->put_screen
            (x,y,(cycle+cycle_offset)%NB_BITMAP);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * draws a square with a prevision look
 */
void U61_Square::draw_prevision(int x, int y,int size)
{
    if (state)
    {
        U61_Global::data.prevision[size]->put_screen
            (x,y,(cycle+cycle_offset)%NB_BITMAP);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * draws a square with a curse background look
 */
void U61_Square::draw_curse_bg(int x, int y,int size)
{
    if (state)
    {
        U61_Global::data.curse_bg[size]->put_screen
            (x,y,(cycle+cycle_offset)%NB_BITMAP);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * draws the square with a curse foreground look
 */
void U61_Square::draw_curse_fg(int x, int y,int size)
{
    if (state)
    {
        U61_Global::data.curse_fg[size]->put_screen
            (x,y,(cycle+cycle_offset)%NB_BITMAP);
    }
}
