/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   playeroptionmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is the main option menu.
 *              its role is to guide the user to other submenus which
 *              will then allow the user to change its settings
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "playeroptionmenu.h"
#include "playermenu.h"
#include "button.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_PlayerOptionMenu::U61_PlayerOptionMenu(U61_Menu *parent)
    : U61_Menu(parent,"Set up your options")
{
    add_item(new U61_Button("Player 1"));
    add_item(new U61_Button("Player 2"));
    add_item(new U61_Button("Player 3"));
    add_item(new U61_Button("Player 4"));
    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_PlayerOptionMenu::validate()
{
    U61_Menu *next_menu;

    next_menu=this;
    switch (selection)
    {
    case 0:
        next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[0]));
        break;
    case 1:
        next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[1]));
        break;
    case 2:
        next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[2]));
        break;
    case 3:
        next_menu=new U61_PlayerMenu(this, &(U61_Global::config.player[3]));
        break;
    }

    return next_menu;
}
