/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        menuinput.cpp
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: February 2000
 * description: input class which handles menu evemts
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a menu input object
 */ 
U61_MenuInput::U61_MenuInput() : U61_Input(NB_KEYS)
{
    init();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a menu input object
 */ 
U61_MenuInput::~U61_MenuInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * initializations of the menu keys
 */
void U61_MenuInput::init()
{
    int i;

    for (i=0;i<NB_KEYS;++i)
    {
        set_menu_key(i,CL_KEY_F12,1,"F12");
    } 

    set_menu_key(0,CL_KEY_A,'a',"A");
    set_menu_key(1,CL_KEY_B,'b',"B");
    set_menu_key(2,CL_KEY_C,'c',"C");
    set_menu_key(3,CL_KEY_D,'d',"D");
    set_menu_key(4,CL_KEY_E,'e',"E");
    set_menu_key(5,CL_KEY_F,'f',"F");
    set_menu_key(6,CL_KEY_G,'g',"G");
    set_menu_key(7,CL_KEY_H,'h',"H");
    set_menu_key(8,CL_KEY_I,'i',"I");
    set_menu_key(9,CL_KEY_J,'j',"J");
    set_menu_key(10,CL_KEY_K,'k',"K");
    set_menu_key(11,CL_KEY_L,'l',"L");
    set_menu_key(12,CL_KEY_M,'m',"M");
    set_menu_key(13,CL_KEY_N,'n',"N");
    set_menu_key(14,CL_KEY_O,'o',"O");
    set_menu_key(15,CL_KEY_P,'p',"P");
    set_menu_key(16,CL_KEY_Q,'q',"Q");
    set_menu_key(17,CL_KEY_R,'r',"R");
    set_menu_key(18,CL_KEY_S,'s',"S");
    set_menu_key(19,CL_KEY_T,'t',"T");
    set_menu_key(20,CL_KEY_U,'u',"U");
    set_menu_key(21,CL_KEY_V,'v',"V");
    set_menu_key(22,CL_KEY_W,'w',"W");
    set_menu_key(23,CL_KEY_X,'x',"X");
    set_menu_key(24,CL_KEY_Y,'y',"Y");
    set_menu_key(25,CL_KEY_Z,'z',"Z");
    set_menu_key(26,CL_KEY_0,'0',"0");
    set_menu_key(27,CL_KEY_1,'1',"1");
    set_menu_key(28,CL_KEY_2,'2',"2");
    set_menu_key(29,CL_KEY_3,'3',"3");
    set_menu_key(30,CL_KEY_4,'4',"4");
    set_menu_key(31,CL_KEY_5,'5',"5");
    set_menu_key(32,CL_KEY_6,'6',"6");
    set_menu_key(33,CL_KEY_7,'7',"7");
    set_menu_key(34,CL_KEY_8,'8',"8");
    set_menu_key(35,CL_KEY_9,'9',"9");
    set_menu_key(36,CL_KEY_SPACE,' ',"Space");
    set_menu_key(37,CL_KEY_LEFT,KEY_LEFT,"Left");
    set_menu_key(38,CL_KEY_RIGHT,KEY_RIGHT,"Right");
    set_menu_key(39,CL_KEY_UP,KEY_UP,"Up");
    set_menu_key(40,CL_KEY_DOWN,KEY_DOWN,"Down");
    set_menu_key(41,CL_KEY_ENTER,KEY_ENTER,"Enter");
    set_menu_key(42,CL_KEY_ESCAPE,KEY_ESCAPE,"Escape");
    set_menu_key(43,CL_KEY_DELETE,KEY_DELETE,"Delete");
    set_menu_key(44,CL_KEY_BACKSPACE,KEY_BACKSPACE,"BackSpace");
}

/*--------------------------------------------------------------------------*/
/*
 * adds a key with the menu repeat settings
 */
void U61_MenuInput::set_menu_key(int i,int cl_code,int ascii,char *label)
{
    U61_Key key;

    key.init(cl_code,ascii,REPEAT_FIRST,REPEAT_STANDARD);
    set_key(i,key);
    keys_label[i]=label;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the scan code associated to an ascii code (or an event code)
 */
int U61_MenuInput::reverse_scan_code(int ascii)
{
    int i;
    int scan_code=CL_KEY_ESCAPE;

    for (i=0;i<keys_size;++i)
    {
        if (keys[i].get_code_out()==ascii)
        {
            scan_code=keys[i].get_code_in();
        } 
    }

    //cout<<"scan_code="<<scan_code<<"\n";
    return scan_code;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the label associated to a key (by scan code)
 */
char *U61_MenuInput::get_label(int code)
{
    char *result="unknown";
    int i;

    for (i=0;i<keys_size;++i)
    {
        if (keys[i].get_code_in()==code)
        {
            result=keys_label[i];
        }
    }
    
    return result;
}
