/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   edit.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a menu item which allows the user to type text
 *              this is usefull to edit the player's name for instance
 */



/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "edit.h"
#include "const.h"
#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'edit' item
 */ 
U61_Edit::U61_Edit(char *label, char *val) : U61_MenuItem()
{
    name=label;
    value=val;
    pos=0;
    update();
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text displayed so that it reflects the value of the item
 */
void U61_Edit::update()
{
    char buffer[U61_STRING_SIZE];

    strcpy(buffer,name);
    strcat(buffer,SEPARATOR);
    strcat(buffer,value);

    set_text(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_Edit::action(int key)
{
    bool changed=false;
    int len;
    int i;

    len=strlen(value); 

    if (isalnum(key) || key==' ')
    {
        for (i=len;i>=pos;--i)
        {
            value[i+1]=value[i];
        }
        value[pos]=key;
        value[MAX_SIZE]=0;
        pos++;
        changed=true;
    }
    else
    {
        switch (key)
        {
        case U61_MenuInput::KEY_RIGHT:
            pos++;
            break;
        case U61_MenuInput::KEY_LEFT:
            pos--;
            break;
        case U61_MenuInput::KEY_DELETE:
            if (pos>=len && pos>0)
            {
                pos--;
            }
            if (len>0)
            {
                suppress();
                changed=true;
            }
            break;
        case U61_MenuInput::KEY_BACKSPACE:
            if (pos>0)
            {
                pos--;
                suppress();
                changed=true;
            }
            break;
        }
    }
    check_pos();

    return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * deletes the current letter
 */
void U61_Edit::suppress()
{
    int len,i;

    len=strlen(value);
    for (i=pos;i<len;++i)
    {
        value[i]=value[i+1];
    }
}

/*--------------------------------------------------------------------------*/
/*
 * checks & corrects the pos of the cursor
 */
void U61_Edit::check_pos()
{
    int len;

    len=strlen(value);
    if (pos>len)
    {
        pos=len;
    }
    if (pos<0)
    {
        pos=0;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * selects the cuurent character
 */
void U61_Edit::select()
{
    int len,sel;

    len=strlen(value);
    if (pos<len)
    {
        sel=strlen(name)+strlen(SEPARATOR)+pos; 
        select_char(sel);
    }
}

