/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   layout.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class contains layout items and is responsible for
 *              placing them on the screen, and then draw them when
 *              necessary. basically it decides to place local players
 *              in the middle of the screen and half/size network players
 *              and place them on the sides
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "layout.h"

#include "global.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default layout
 */ 
U61_Layout::U61_Layout()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the layout
 */ 
U61_Layout::~U61_Layout()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * resets the layout, ie resets all the layout items
 */
void U61_Layout::reset()
{
    int i;

    for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
        items[i].reset();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * inits the layout for single player mode
 */
void U61_Layout::init_alone(U61_Player *p)
{
    reset();

    items[0].init(p,
                  U61_Global::data.screen_w/2,
                  U61_Global::data.screen_h/2,
                  U61_Data::SIZE_BIG);
    //cout<<"layout initialized with "<<p->get_name()<<"\n";
}

/*--------------------------------------------------------------------------*/
/*
 * draws the layout (draws all the layoutitems)
 */
void U61_Layout::draw()
{
    int i;

    if (exists_changed_background() || background==NULL)
    {
        prepare_background();
    }

    U61_Global::data.back->put_screen(0,0);
    for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
        items[i].draw();
    }    
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if one of the backgrounds has changed
 */
bool U61_Layout::exists_changed_background()
{
    bool found;
    int i;
 
    found=false;
    for (i=0;i<NB_PLAYERS_TOTAL;++i)
    {
        found=found || items[i].has_background_changed();
    }

    return found;
}

/*--------------------------------------------------------------------------*/
/*
 * prepares the background
 * we use a bitmap to hold the background of the game, ie the global bg tile
 * plus the backgrounds of each bitmap to avoid redrawing the map
 * backgrounds all the time, since they don't change very often
 */
void U61_Layout::prepare_background()
{

}
