/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   startmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu allows you to start a new game, it may be
 *              a single, multiplayer or networked game
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "startmenu.h"
#include "button.h"
#include "emptymenu.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the start menu
 */ 
U61_StartMenu::U61_StartMenu(U61_Menu *parent) : U61_Menu(parent)
{
    add_item(new U61_Button("Play Alone"));
    add_item(new U61_Button("Local Multiplayer Game"));
    add_item(new U61_Button("New Network Game"));
    add_item(new U61_Button("Join Network Game"));
    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_StartMenu::validate()
{
    U61_Menu *next_menu;

    next_menu=this;
    switch (selection)
    {
    case 0:
        next_menu=new U61_EmptyMenu(this);
        U61_Global::game.start_local_alone();
        break;
    case 1:
        next_menu=new U61_EmptyMenu(this);
        U61_Global::game.start_local_multiplayer();
        break;
    case 2:
        next_menu=new U61_EmptyMenu(this);
        U61_Global::game.start_network_new();
        break;
    case 3:
        next_menu=new U61_EmptyMenu(this);
        U61_Global::game.start_network_join();
        break;
    }

    return next_menu;
}
