/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * This project is protected by the GPL, see copying.txt                    *
 *                                                                          *
 ****************************************************************************/

/* name:        menuinput.cpp
 * author       U-Foot (ufoot@bigfoot.com)
 * last update: February 2000
 * description: input class which handles menu evemts
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a menu input object
 */ 
U61_MenuInput::U61_MenuInput() : U61_Input(NB_KEYS)
{
    init();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a menu input object
 */ 
U61_MenuInput::~U61_MenuInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * initializations of the menu keys
 */
void U61_MenuInput::init()
{
    int i;

    for (i=0;i<NB_KEYS;++i)
    {
        set_menu_key(i,CL_KEY_F12,' ');
    } 

    set_menu_key(0,CL_KEY_A,'a');
    set_menu_key(1,CL_KEY_B,'b');
    set_menu_key(2,CL_KEY_C,'c');
    set_menu_key(3,CL_KEY_D,'d');
    set_menu_key(4,CL_KEY_E,'e');
    set_menu_key(5,CL_KEY_F,'f');
    set_menu_key(6,CL_KEY_G,'g');
    set_menu_key(7,CL_KEY_H,'h');
    set_menu_key(8,CL_KEY_I,'i');
    set_menu_key(9,CL_KEY_J,'j');
    set_menu_key(10,CL_KEY_K,'k');
    set_menu_key(11,CL_KEY_L,'l');
    set_menu_key(12,CL_KEY_M,'m');
    set_menu_key(13,CL_KEY_N,'n');
    set_menu_key(14,CL_KEY_O,'o');
    set_menu_key(15,CL_KEY_P,'p');
    set_menu_key(16,CL_KEY_Q,'q');
    set_menu_key(17,CL_KEY_R,'r');
    set_menu_key(18,CL_KEY_S,'s');
    set_menu_key(19,CL_KEY_T,'t');
    set_menu_key(20,CL_KEY_U,'u');
    set_menu_key(21,CL_KEY_V,'v');
    set_menu_key(22,CL_KEY_W,'w');
    set_menu_key(23,CL_KEY_X,'x');
    set_menu_key(24,CL_KEY_Y,'y');
    set_menu_key(25,CL_KEY_Z,'z');
    set_menu_key(26,CL_KEY_0,'0');
    set_menu_key(27,CL_KEY_1,'1');
    set_menu_key(28,CL_KEY_2,'2');
    set_menu_key(29,CL_KEY_3,'3');
    set_menu_key(30,CL_KEY_4,'4');
    set_menu_key(31,CL_KEY_5,'5');
    set_menu_key(32,CL_KEY_6,'6');
    set_menu_key(33,CL_KEY_7,'7');
    set_menu_key(34,CL_KEY_8,'8');
    set_menu_key(35,CL_KEY_9,'9');
    set_menu_key(36,CL_KEY_LEFT,8);
    set_menu_key(37,CL_KEY_RIGHT,9);
    set_menu_key(38,CL_KEY_UP,11);
    set_menu_key(39,CL_KEY_DOWN,10);
    set_menu_key(40,CL_KEY_ENTER,13);
    set_menu_key(41,CL_KEY_ESCAPE,0);
}

/*--------------------------------------------------------------------------*/
/*
 * adds a key with the menu repeat settings
 */
void U61_MenuInput::set_menu_key(int i,int cl_code,int ascii)
{
    U61_Key key;

    key.init(cl_code,ascii,REPEAT_FIRST,REPEAT_STANDARD);
    set_key(i,key);
}
