/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   letter.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the letter class allows the drawing of funny dancing letters
 *              it contains information about the letter offset and provides
 *              functions to draw it
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "letter.h"
#include "time.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a letter
 */ 
U61_Letter::U61_Letter(CL_Font *fnt,char code)
{
    set_font(fnt);
    ascii=code; 
    disable_dance(); 
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the letter
 */ 
U61_Letter::~U61_Letter()
{
//    cout<<"Freeing letter "<<ascii<<"\n";
}

/*--------------------------------------------------------------------------*/
/*
 * enables the dance mode, in which the letters move
 */
void U61_Letter::enable_dance()
{
    if (!dance_state)
    {
        dance_state=true;

        last_time=U61_Time::for_effect();

        dx=0; 
        dy=0; 
        change_vx();
        change_vy();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * disables the dance mode, in which the letters move
 */
void U61_Letter::disable_dance()
{
    dance_state=false;

    dx=0;
    dy=0;
}

/*--------------------------------------------------------------------------*/
/*
 * computes all the movements off the letter
 */
void U61_Letter::compute()
{
    int time;

    time=U61_Time::for_effect();
    while(last_time<time)
    {
        dx+=vx;
        dy+=vy;
        
        if (dx<-W_MAX_MOVE||dx>W_MAX_MOVE)
        {
            dx-=vx;
            change_vx();
        }
        if (dy<-H_MAX_MOVE||dy>H_MAX_MOVE)
        {
            dy-=vy;
            change_vy();
        }

        last_time+=SLOW_FACTOR;
    }    
}

/*--------------------------------------------------------------------------*/
/*
 * finds a new vx value
 */
void U61_Letter::change_vx()
{
    static int choice=-1;

    if (U61_Time::for_effect()%2)
    {
        choice=(choice==-1) ? 1 : -1;
    }
    vx=choice;
}

/*--------------------------------------------------------------------------*/
/*
 * finds a new vy value
 */
void U61_Letter::change_vy()
{
    static int choice=-1;

    if (U61_Time::for_effect()%2)
    {
        choice=(choice==-1) ? 1 : -1;
    }
    vy=choice;
}

/*--------------------------------------------------------------------------*/
/*
 * changes the ascii code of the letter
 */
char U61_Letter::operator =(char code)
{
    ascii=code;

    return code;
}

/*--------------------------------------------------------------------------*/
/*
 * draws the letter onto a bitmap
 */
void U61_Letter::set_font(CL_Font *fnt)
{
    font=fnt;
}

/*--------------------------------------------------------------------------*/
/*
 * draws the letter onto a bitmap
 */
void U61_Letter::draw(int x,int y)
{
    char text[2];

    text[0]=ascii;
    text[1]=0;

    if (dance_state)
    {
        compute();
    }
    font->print_center(x+dx,y+dy,text);
}

/*--------------------------------------------------------------------------*/
/*
 * returns the height of the letter, in pixels
 */
int U61_Letter::get_height()
{
    int height;

    height=font->get_height();
    if (dance_state)
    {
        height+=H_MAX_MOVE;
    }
    return height;
}

/*--------------------------------------------------------------------------*/
/*
 * returns the width of the letter, in pixels
 */
int U61_Letter::get_width()
{
    char text[2];
    int width;

    text[0]=ascii;
    text[1]=0;

    width=font->get_text_width(text);
    if (dance_state)
    {
        width+=W_MAX_MOVE;
    }
    return width;
}

