/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   layoutitem.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a layout item is a map plus the informations to draw it
 *              this includes its position, its size etc...
 *              layout items are initialized and parametered 
 *              in the layout class
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "layoutitem.h"
#include "layout.h"
#include "global.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a default layoutitem
 */ 
U61_LayoutItem::U61_LayoutItem()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * frees the layoutitem
 */ 
U61_LayoutItem::~U61_LayoutItem()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * resets the layout item, ie sets it inactive and unvisible
 */
void U61_LayoutItem::reset()
{
    active=false;
    bg_changed=true;
}

/*--------------------------------------------------------------------------*/
/*
 * initializes the layout item
 */
void U61_LayoutItem::init(U61_Player *p,int x,int y,int s)
{
    active=true;
    player=p;
    bg_changed=true;
    size=s; 
    x_center=x;
    y_center=y;
    calc_coords();
}

/*--------------------------------------------------------------------------*/
/*
 * calculates the coordinates of a layout item, 
 * the reference values are center_x center_y and size
 * all other values are calculated, depending on the data file
 * that has been loaded (size of backgrounds etc...)
 */
void U61_LayoutItem::calc_coords()
{
    x_map=x_center-U61_Global::data.map_w[size]/2;
    y_map=y_center-U61_Global::data.map_h[size]/2;
}

/*--------------------------------------------------------------------------*/
/*
 * returns true if a redraw of the background is neede
 */
bool U61_LayoutItem::has_background_changed()
{
    return bg_changed;
}

/*--------------------------------------------------------------------------*/
/*
 * draws the backgounds onto a specific bitmap
 */
void U61_LayoutItem::draw_background(CL_Canvas *target)
{
    if (active)
    {
    } 
}

/*--------------------------------------------------------------------------*/
/*
 * draws the map and various infos
 */
void U61_LayoutItem::draw()
{
    if (active)
    {
        player->draw(x_map,y_map,size);
    }
}
