/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   config.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the config object holds all the values which are stored
 *              on the HD between two game sessions. it would for instance
 *              store the player names and key settings
 *              it basically provides functions to load and save all the
 *              game parameters, and makes these parameters usable by any
 *              other class.
 *              it also provides some function which help handling game
 *              settings in general
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "config.h"
#include "platform.h"
#include "script.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation with default values
 */ 
U61_Config::U61_Config()
{
    reset();
}

/*--------------------------------------------------------------------------*/
/*
 * destruction
 */
U61_Config::~U61_Config()
{

}

/*--------------------------------------------------------------------------*/
/* 
 * initialization with default values
 */ 
void U61_Config::reset()
{
    int i;

    launch_count=0;

    for (i=0;i<NB_PLAYERS;++i)
    {
        player[i].reset();
    }    

    data_file="classic.dat";
    script_file="classic.lua";
}

/*--------------------------------------------------------------------------*/
/* 
 * initialization with values from the config file
 */ 
bool U61_Config::read()
{
    bool ok=false;
    char *filename;

    reset();

    //cout<<"read config\n";
    filename=U61_Platform::get_config_file();
    cout<<"Loading config from \""<<filename<<"\".\n";

    U61_Script::do_file(filename);

    //cout<<"coucou conf\n";
    if (U61_Script::get_global_int(ID_DUMMY,0)==DUMMY_VALUE)
    {
        ok=true;
    }
    launch_count=U61_Script::get_global_int(ID_LAUNCH_COUNT,0);
    data_file=U61_Script::get_global_str(ID_DATA_FILE,"classic.dat");
    script_file=U61_Script::get_global_str(ID_SCRIPT_FILE,"classic.lua");
  
    return ok;
}

/*--------------------------------------------------------------------------*/
/* 
 * saves the values to the config file
 */ 
bool U61_Config::write()
{
    bool ok=false;
    char *filename;
    FILE *file;

    //cout<<"write config\n";
    filename=U61_Platform::get_config_file();
    cout<<"Writing config to \""<<filename<<"\".\n";
    file=fopen(filename,"w");

    if (file!=NULL)
    {
        ok=true;
        ok=ok && write_int(file,ID_DUMMY,DUMMY_VALUE);
        ok=ok && write_int(file,ID_LAUNCH_COUNT,launch_count+1);
        ok=ok && write_str(file,ID_DATA_FILE,data_file);
        ok=ok && write_str(file,ID_SCRIPT_FILE,script_file);
        fclose(file);
    } 

    return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * loads the user scripts that will be used by the script module
 */
bool U61_Config::load_script()
{
    bool ok=false;
    char buffer[1000];

    strcpy(buffer,U61_Platform::get_data_path());
    strcat(buffer,script_file);
    
    ok=U61_Script::do_file(buffer);
    
    return ok;
}

/*--------------------------------------------------------------------------*/
/*
 * saves a numeric entry into the config file
 */
bool U61_Config::write_str(FILE *file,char *name,char *value)
{
    char buffer[1000];
    bool ok;

    strcpy(buffer,name);
    strcat(buffer," = \"");
    strcat(buffer,value);
    strcat(buffer,"\"\n");

    ok=(fwrite(buffer,strlen(buffer),1,file)>0);

    return ok;
} 

/*--------------------------------------------------------------------------*/
/*
 * saves a numeric entry into the config file
 */
bool U61_Config::write_int(FILE *file,char *name,int value)
{
    char buffer[1000];
    char buffer2[20];
    bool ok;

    sprintf(buffer2,"%d",value);

    strcpy(buffer,name);
    strcat(buffer," = ");
    strcat(buffer,buffer2);
    strcat(buffer,"\n");

    ok=(fwrite(buffer,strlen(buffer),1,file)>0);

    return ok;
} 



