#!/usr/bin/clisp
;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;; load TL before using its methods
(let ((tl-home-folder "") (dirSepar "/")) (let ((*error-output* (make-broadcast-stream))) ; bit sink, like dev/null
 (require (concatenate 'string tl-home-folder "core" dirSepar "PackDef")) (funcall (find-symbol "TL-SET-HOME-PATH" "TWINLISP") tl-home-folder dirSepar) (require (concatenate 'string tl-home-folder "core" dirSepar "loadTL"))))
;; set paths
(let ((envTlPath (getenv "TLPATH")) (dirSepar (tl-dir-sep))) (cond (envTlPath (do (colInd) (nil) (setf colInd (index envTlPath #\:)) (cond (colInd (cond ((_!=_ (len (_getitem_ envTlPath (_make-slice_ nil colInd nil))) 0) (tl-append *LOAD-PATHS* (_+_ (_getitem_ envTlPath (_make-slice_ nil colInd nil)) dirSepar)))) (setf envTlPath (_getitem_ envTlPath (_make-slice_ (_+_ colInd 1) nil nil)))) (t (cond ((_!=_ (len envTlPath) 0) (tl-append *LOAD-PATHS* (_+_ envTlPath dirSepar)))) (return-from nil ())))))) (tl-append *LOAD-PATHS* (_+_ (_+_ (tl-home-path) "site-packages") dirSepar) (_+_ (_+_ (tl-home-path) "dist-packages") dirSepar)))
;; act according to specified &*args*
(let ((treplOn nil) (verbose nil) (fileToLoad nil) (compiling nil) (dirSepar (tl-dir-sep))) (let (act) (setf act (block proc-arg (do () ((endp *args*) :trepl) (cond ((_==_ (_getitem_ (car *args*) 0) #\-) (tl-for (char (_getitem_ (car *args*) (_make-slice_ 1 nil nil))) (nil) (tl-case char nil (#\h (return-from proc-arg :help)) (#\t (setf *args* (cdr *args*)) (return-from proc-arg :translate)) (#\i (setf treplOn t)) (#\v (setf verbose t)) (#\c (setf compiling t))))) (t (setf fileToLoad (car *args*)) (setf *args* (cdr *args*)) (return-from proc-arg :load))) (setf *args* (cdr *args*))))) (tl-case act nil (:help (_<<_ (cout) "usage: tlisp [ -h |
              [-i] [-v] -t files |
              [-i] [-v] [-c] file [args] ]
When no option or file given, TwinLisp interpreter is entered.
Available options:
 -h  : print this help message and exit
 -t  : translate files given after this option
 -i  : enter interpreter after loading a file, or translation
 -v  : verbose display
 -c  : file is loaded and statements are compiled on the fly
File is loaded and executed with &*args* == list(args).
Other environment variables:
TLSTARTUP : file executed on interactive startup (no default)")) (:translate (translate-files *args* verbose)) (:trepl (handler-case (progn (let (startupFile) (setf startupFile (getenv "TLSTARTUP")) (cond ((_!=_ (len startupFile) 0) (load startupFile))))) (error (er) (_<<_ (cout) (_%_ "~%Error occured while loading startup file:~%~A" er)))) (tl-load (_+_ (_+_ (_+_ (tl-home-path) "core") dirSepar) "interpreter"))) (:load (tl-load fileToLoad :compiling compiling :verbose verbose :if-does-not-exist t) (cond (treplOn (tl-load (_+_ (_+_ (_+_ (tl-home-path) "core") dirSepar) "interpreter"))))))))
