;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(in-package "TWINLISP")
;; errors
(define-condition index-error (simple-error) ((container :initarg :container) (index :initarg :index)))
(define-condition null-list-error (simple-error) ())
;; _slice_ type for use with _getitem_
(defstruct (_slice_) start end step)
;; _iterator_ class
(defclass _iterator_ () ((step :initarg :step)))
;; _list-iterator_
(defclass _list-iterator_ (_iterator_) ((iterStarted :initform nil) (lastCons :initarg :list :type list)))
;; _sequence-iterator_
(defclass _sequence-iterator_ (_iterator_) ((iterStarted :initform nil) (seq :initarg :sequence) (lastIndex :initform (_unary-_ 1) :type integer)))
