;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslFormBuildingTwo (unittest:testcase) ((unittest:tName :initform "TestTranslFormBuildingTwo.twl") (unittest:tFuns :initform '(test-getForms-BlockForm-1 test-getForms-BlockForm-2 test-getForms-BlockForm-3 test-getForms-BlockForm-4 test-getForms-BlockForm-5 test-getForms-BlockForm-6 test-getForms-BlockForm-7 test-getForms-BlockForm-8 test-getForms-BlockForm-9 test-getForms-BlockForm-10 test-getForms-BlockForm-11 test-getForms-LambdaList-1 test-getForms-LambdaList-2 test-getForms-LambdaList-3 test-getForms-LambdaList-4 test-getForms-LambdaList-5 test-getForms-LambdaList-6 test-getForms-LambdaList-7 test-getForms-LambdaList-8 test-getForms-LambdaList-9 test-getForms-LambdaList-10 test-getForms-LambdaList-11 test-getForms-LambdaList-12 test-getForms-MacLambdaList-1 test-getForms-LetList-1 test-getForms-LetList-2 test-getForms-LetList-3 test-getForms-LetList-4 test-getForms-LetList-5 test-getForms-BlockName-1 test-getForms-BlockName-2 test-getForms-BlockName-3 test-getForms-BlockName-4 test-getForms-BlockName-5 test-getForms-DoLists-1 test-getForms-DoLists-2 test-getForms-DoLists-3 test-getForms-DoLists-4 test-getForms-DoLists-5 test-getForms-DoLists-6 test-getForms-DoLists-7 test-getForms-DoLists-8 test-getForms-DoLists-9 test-getForms-Break-1 test-getForms-Break-2 test-getForms-Break-3 test-getForms-Break-4 test-getForms-Break-5 test-getForms-Break-6 test-getForms-Return-1 test-getForms-Return-2 test-getForms-Return-3 test-getForms-Return-4 test-getForms-If-1 test-getForms-If-2 test-getForms-If-3 test-getForms-If-4 test-getForms-If-5 test-getForms-If-6 test-getForms-Flet-1 test-getForms-Flet-2 test-getForms-Flet-And-Return-1))))
(cl:defmethod test-getForms-BlockForm-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo() {
              ~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo\\
                () {
              ~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo
                () {
              ~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo ()
             {~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo() {
              progn{~(), ~()}
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:progn") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_))))) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-6 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo {
              ~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-7 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo 
             {~()
              ~()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-8 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def $foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "foo")) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-9 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def `$foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list SHORTCUT_TYPE "`" (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "foo"))) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-10 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def setter foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "foo")))) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-BlockForm-11 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def setter $foo {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "foo"))))) (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-LambdaList-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-LambdaList-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-LambdaList-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-LambdaList-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b,) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-LambdaList-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b,&&key) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "&key")))))))))))))
(cl:defmethod test-getForms-LambdaList-6 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,&&optional,b) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list ATOM_TYPE "b")))))))))))))
(cl:defmethod test-getForms-LambdaList-7 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b=5) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "5"))))))))))))))))
(cl:defmethod test-getForms-LambdaList-8 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b=5=?bPresent) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "5") (cl:list ATOM_TYPE "bPresent"))))))))))))))))
(cl:defmethod test-getForms-LambdaList-9 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,b=?bPresent) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "bPresent"))))))))))))))))
(cl:defmethod test-getForms-LambdaList-10 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,bKey->b=?bPresent) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&key") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bKey") (cl:list ATOM_TYPE "b")))) (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "bPresent"))))))))))))))))
(cl:defmethod test-getForms-LambdaList-11 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,bKey->b=5=?bPresent) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&key") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "bKey") (cl:list ATOM_TYPE "b")))) (cl:list ATOM_TYPE "5") (cl:list ATOM_TYPE "bPresent"))))))))))))))))
(cl:defmethod test-getForms-LambdaList-12 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo(a,&&aux b=5) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "&aux") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "5"))))))))))))))))
(cl:defmethod test-getForms-MacLambdaList-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "mac foo(a,.(**body),b=5=?bPresent) {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defmacro") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "&body") (cl:list ATOM_TYPE "body")))) (cl:list ATOM_TYPE "&optional") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "5") (cl:list ATOM_TYPE "bPresent"))))))))))))))))
(cl:defmethod test-getForms-LetList-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "let () {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-LetList-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "let {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-LetList-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "let (x,y) {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "y")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-LetList-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "let (x,y=a) {y}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "a"))))))) (cl:list ATOM_TYPE "y"))))))))))
(cl:defmethod test-getForms-LetList-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "let (x,y=a=5) {y}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:let") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "x") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "y") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "5")))))))))) (cl:list ATOM_TYPE "y"))))))))))
(cl:defmethod test-getForms-BlockName-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "block {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:block") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-BlockName-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "block nil {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:block") (cl:list ATOM_TYPE "cl:nil") (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-BlockName-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "block foo {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:block") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-BlockName-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "block $foo {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:block") (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "foo")) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-BlockName-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "block `$foo {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:block") (cl:list SHORTCUT_TYPE "`" (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "foo"))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do () {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do () () {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do () (a==2) {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2"))))))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do () (a==2,\"Some computed form\",\"Return result\") {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2")))) (cl:list ATOM_TYPE "\"Some computed form\"") (cl:list ATOM_TYPE "\"Return result\"")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do (a) (a==2,\"Return result\") {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2")))) (cl:list ATOM_TYPE "\"Return result\"")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-6 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do (a=0,b) (a==2,\"Return result\") {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0")))) (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2")))) (cl:list ATOM_TYPE "\"Return result\"")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-7 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do (a=0->a+b,b=1) {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "1"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-8 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do (a->a+b,b=1) (a==2,\"Return result\") {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "cl:nil") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "1"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2")))) (cl:list ATOM_TYPE "\"Return result\"")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-DoLists-9 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "do 
            (a=0->a+b)
            (a==2,\"Return result\") 
            {a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "0") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_==_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "2")))) (cl:list ATOM_TYPE "\"Return result\"")))) (cl:list ATOM_TYPE "a"))))))))))
(cl:defmethod test-getForms-Break-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break
          x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "cl:nil") (cl:list FORM_TYPE (tl:_make-vector_))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3"))))))))))
(cl:defmethod test-getForms-Break-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "cl:nil") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3")))))))))))))
(cl:defmethod test-getForms-Break-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break from blockName x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "blockName") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3")))))))))))))
(cl:defmethod test-getForms-Break-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break from blockName
          x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "blockName") (cl:list FORM_TYPE (tl:_make-vector_))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3"))))))))))
(cl:defmethod test-getForms-Break-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break from $blockName
          x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "blockName")) (cl:list FORM_TYPE (tl:_make-vector_))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3"))))))))))
(cl:defmethod test-getForms-Break-6 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "break from `$blockName
          x=3") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list SHORTCUT_TYPE "`" (cl:list SHORTCUT_TYPE "," (cl:list ATOM_TYPE "blockName"))) (cl:list FORM_TYPE (tl:_make-vector_))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "3"))))))))))
(cl:defmethod test-getForms-Return-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo {return}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_))))))))))))))
(cl:defmethod test-getForms-Return-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo {return a}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "a")))))))))))))
(cl:defmethod test-getForms-Return-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo {return a@b@c}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:values") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "c"))))))))))))))))
(cl:defmethod test-getForms-Return-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "def foo {do () () {return a@b@c}}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:defun") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:do") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE LISP_NIL)))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:values") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b") (cl:list ATOM_TYPE "c")))))))))))))))))))
(cl:defmethod test-getForms-If-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))))))))))))
(cl:defmethod test-getForms-If-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}
          elif (c) {y=0}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0"))))))))))))))))
(cl:defmethod test-getForms-If-3 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}
          elif (c) {y=0}
          elif (d) {y=1}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "d") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "1"))))))))))))))))
(cl:defmethod test-getForms-If-4 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}
          elif (c) {y=0}
          else {foo()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:t") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo"))))))))))))))))
(cl:defmethod test-getForms-If-5 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}
          elif (b) {x=0}
          elif (c) {y=0}
          else {foo()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "c") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "y") (cl:list ATOM_TYPE "0"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:t") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo"))))))))))))))))
(cl:defmethod test-getForms-If-6 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "if (a) {x=b}
          else {foo()}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:cond") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:setf") (cl:list ATOM_TYPE "x") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:t") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo"))))))))))))))))
(cl:defmethod test-getForms-Flet-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "flet {}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:flet") (cl:list FORM_TYPE (tl:_make-vector_)))))))))))
(cl:defmethod test-getForms-Flet-2 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "flet foo (a,b) {a+b}
               boo (a,b) {a*b}
               pr {}
             {foo(1,2)-boo(3,4)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:flet") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_+_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_*_") (cl:list ATOM_TYPE "a") (cl:list ATOM_TYPE "b"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "pr") (cl:list FORM_TYPE (tl:_make-vector_)))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "1") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo") (cl:list ATOM_TYPE "3") (cl:list ATOM_TYPE "4"))))))))))))))))
(cl:defmethod test-getForms-Flet-And-Return-1 ((ts TestTranslFormBuildingTwo)) (cl:let (st) (cl:setf st "flet foo {return}
               boo (a) {return a}
               pr (b) {return}
             {foo(1,2)-boo(3,4)}") (cl:let (forms) (cl:setf forms (getForms (new GrowingVect :streamObj (make-string-input-stream st)) (makeLevelInfo))) (unittest:assertEqual ts forms (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:flet") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "foo") (cl:list FORM_TYPE (tl:_make-vector_)))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "a")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "boo") (cl:list ATOM_TYPE "a"))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "pr") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "b")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "cl:return-from") (cl:list ATOM_TYPE "pr") (cl:list FORM_TYPE (tl:_make-vector_))))))))))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "tl:_-_") (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "foo") (cl:list ATOM_TYPE "1") (cl:list ATOM_TYPE "2")))) (cl:list FORM_TYPE (tl:_make-vector_ :initContent (cl:list (cl:list ATOM_TYPE "boo") (cl:list ATOM_TYPE "3") (cl:list ATOM_TYPE "4"))))))))))))))))
