;
;Copyright (C) 2006 Mikalai Birukou
;
;This file is part of TwinLisp.
;
;    TwinLisp is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    TwinLisp is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with TwinLisp; if not, write to the Free Software
;    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
(cl:in-package "TWINLISP")
(cl:defclass TestTranslElemSearchFuncs (unittest:testcase) ((unittest:tName :initform "TestTranslElemSearchFuncs.twl") (unittest:tFuns :initform '(test-getElemsInBrackets-1 test-GetElemsInBrackets-2 test-GetElemsInBrackets-3 test-GetElemsInBrackets-4 test-SkipElems test-GetRequiredElemInd))))
(cl:defmethod test-getElemsInBrackets-1 ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "(a)") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (cl:let (elems end) (cl:setf (cl:values elems end) (getElemsInBrackets 0 gv)) (unittest:assertEqual ts (len elems) 1) (unittest:assertEqual ts end 2) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 0) 'value) "a") (cl:setf (cl:values elems end) (getElemsInBrackets 0 gv cl:t)) (unittest:assertEqual ts (len elems) 3) (unittest:assertEqual ts end 3) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 0) 'type) "(") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 1) 'value) "a") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 2) 'type) ")")))))
(cl:defmethod test-GetElemsInBrackets-2 ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "~((a)+b[{(s)}])") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (cl:let (elems end) (cl:setf (cl:values elems end) (getElemsInBrackets 0 gv)) (unittest:assertEqual ts (len elems) 12) (unittest:assertEqual ts end 13) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 8) 'value) "s") (cl:setf (cl:values elems end) (getElemsInBrackets 0 gv cl:t)) (unittest:assertEqual ts (len elems) 14) (unittest:assertEqual ts end 14) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 0) 'type) "~(") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 9) 'value) "s") (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 13) 'type) ")")))))
(cl:defmethod test-GetElemsInBrackets-3 ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "~((a),
                b[{(s)}])") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (cl:let (elems end) (cl:setf (cl:values elems end) (getElemsInBrackets 0 gv)) (unittest:assertEqual ts (len elems) 14) (unittest:assertEqual ts end 15) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ elems 4) 'type) LINE_END_ELEM)))))
(cl:defmethod test-GetElemsInBrackets-4 ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "~((a,
                 b[{(s)}])") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getElemsInBrackets 0 gv)) (cl:setf st "~((a),
                b[(s)}])") (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (unittest:assertCondition ts tl-syntax-error (getElemsInBrackets 0 gv)))))
(cl:defmethod test-SkipElems ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "def foo () 
                  { a , b \\ t g * ;comment
                    c}") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (cl:let (elemFound ind) (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) 1 gv)) (unittest:assertTrue ts elemFound) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'value) "foo") (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) 3 gv)) (unittest:assertTrue ts elemFound) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'type) "(") (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) 6 gv)) (unittest:assertFalse ts elemFound) (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) 6 gv cl:nil)) (unittest:assertTrue ts elemFound) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'type) "{") (unittest:assertEqual ts (nth-value 1 (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) ind gv)) ind) (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM ",")) (tl:_+_ ind 3) gv)) (unittest:assertTrue ts elemFound) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'value) "b") (cl:setf (cl:values elemFound ind) (skipElems (tl:_make-vector_ :initContent (cl:list WHITE_ELEM)) (tl:_+_ ind 1) gv)) (unittest:assertTrue ts elemFound) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'value) "c")))))
(cl:defmethod test-GetRequiredElemInd ((ts TestTranslElemSearchFuncs)) (cl:let (st) (cl:setf st "def foo \\
                      ()
                      {}") (cl:let (gv) (cl:setf gv (new GrowingVect :streamObj (make-string-input-stream st))) (cl:let (ind) (cl:setf ind (getRequiredElemInd SYMB_ELEM 1 gv)) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'value) "foo") (cl:setf ind (getRequiredElemInd "(" 3 gv)) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'type) "(") (unittest:assertCondition ts tl-syntax-error (getRequiredElemInd "{" (tl:_+_ ind 2) gv)) (cl:setf ind (getRequiredElemInd "{" (tl:_+_ ind 2) gv cl:nil)) (unittest:assertEqual ts (cl:slot-value (tl:_getitem_ gv ind) 'type) "{")))))
